package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryBagRemaining invokes the companyreg.QueryBagRemaining API synchronously
func (client *Client) QueryBagRemaining(request *QueryBagRemainingRequest) (response *QueryBagRemainingResponse, err error) {
	response = CreateQueryBagRemainingResponse()
	err = client.DoAction(request, response)
	return
}

// QueryBagRemainingWithChan invokes the companyreg.QueryBagRemaining API asynchronously
func (client *Client) QueryBagRemainingWithChan(request *QueryBagRemainingRequest) (<-chan *QueryBagRemainingResponse, <-chan error) {
	responseChan := make(chan *QueryBagRemainingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryBagRemaining(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryBagRemainingWithCallback invokes the companyreg.QueryBagRemaining API asynchronously
func (client *Client) QueryBagRemainingWithCallback(request *QueryBagRemainingRequest, callback func(response *QueryBagRemainingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryBagRemainingResponse
		var err error
		defer close(result)
		response, err = client.QueryBagRemaining(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryBagRemainingRequest is the request struct for api QueryBagRemaining
type QueryBagRemainingRequest struct {
	*requests.RpcRequest
	BizType string `position:"Query" name:"BizType"`
}

// QueryBagRemainingResponse is the response struct for api QueryBagRemaining
type QueryBagRemainingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      int64  `json:"Data" xml:"Data"`
}

// CreateQueryBagRemainingRequest creates a request to invoke QueryBagRemaining API
func CreateQueryBagRemainingRequest() (request *QueryBagRemainingRequest) {
	request = &QueryBagRemainingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "QueryBagRemaining", "", "")
	request.Method = requests.GET
	return
}

// CreateQueryBagRemainingResponse creates a response to parse from QueryBagRemaining response
func CreateQueryBagRemainingResponse() (response *QueryBagRemainingResponse) {
	response = &QueryBagRemainingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
