package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteConsumerChannel invokes the dts.DeleteConsumerChannel API synchronously
func (client *Client) DeleteConsumerChannel(request *DeleteConsumerChannelRequest) (response *DeleteConsumerChannelResponse, err error) {
	response = CreateDeleteConsumerChannelResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteConsumerChannelWithChan invokes the dts.DeleteConsumerChannel API asynchronously
func (client *Client) DeleteConsumerChannelWithChan(request *DeleteConsumerChannelRequest) (<-chan *DeleteConsumerChannelResponse, <-chan error) {
	responseChan := make(chan *DeleteConsumerChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteConsumerChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteConsumerChannelWithCallback invokes the dts.DeleteConsumerChannel API asynchronously
func (client *Client) DeleteConsumerChannelWithCallback(request *DeleteConsumerChannelRequest, callback func(response *DeleteConsumerChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteConsumerChannelResponse
		var err error
		defer close(result)
		response, err = client.DeleteConsumerChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteConsumerChannelRequest is the request struct for api DeleteConsumerChannel
type DeleteConsumerChannelRequest struct {
	*requests.RpcRequest
	ConsumerGroupId string `position:"Query" name:"ConsumerGroupId"`
	DtsJobId        string `position:"Query" name:"DtsJobId"`
	DtsInstanceId   string `position:"Query" name:"DtsInstanceId"`
}

// DeleteConsumerChannelResponse is the response struct for api DeleteConsumerChannel
type DeleteConsumerChannelResponse struct {
	*responses.BaseResponse
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        string `json:"Success" xml:"Success"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateDeleteConsumerChannelRequest creates a request to invoke DeleteConsumerChannel API
func CreateDeleteConsumerChannelRequest() (request *DeleteConsumerChannelRequest) {
	request = &DeleteConsumerChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DeleteConsumerChannel", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteConsumerChannelResponse creates a response to parse from DeleteConsumerChannel response
func CreateDeleteConsumerChannelResponse() (response *DeleteConsumerChannelResponse) {
	response = &DeleteConsumerChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
