package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewaySlb invokes the mse.ListGatewaySlb API synchronously
func (client *Client) ListGatewaySlb(request *ListGatewaySlbRequest) (response *ListGatewaySlbResponse, err error) {
	response = CreateListGatewaySlbResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewaySlbWithChan invokes the mse.ListGatewaySlb API asynchronously
func (client *Client) ListGatewaySlbWithChan(request *ListGatewaySlbRequest) (<-chan *ListGatewaySlbResponse, <-chan error) {
	responseChan := make(chan *ListGatewaySlbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewaySlb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewaySlbWithCallback invokes the mse.ListGatewaySlb API asynchronously
func (client *Client) ListGatewaySlbWithCallback(request *ListGatewaySlbRequest, callback func(response *ListGatewaySlbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewaySlbResponse
		var err error
		defer close(result)
		response, err = client.ListGatewaySlb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewaySlbRequest is the request struct for api ListGatewaySlb
type ListGatewaySlbRequest struct {
	*requests.RpcRequest
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// ListGatewaySlbResponse is the response struct for api ListGatewaySlb
type ListGatewaySlbResponse struct {
	*responses.BaseResponse
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string    `json:"Message" xml:"Message"`
	Code           int       `json:"Code" xml:"Code"`
	Success        bool      `json:"Success" xml:"Success"`
	Data           []Sources `json:"Data" xml:"Data"`
}

// CreateListGatewaySlbRequest creates a request to invoke ListGatewaySlb API
func CreateListGatewaySlbRequest() (request *ListGatewaySlbRequest) {
	request = &ListGatewaySlbRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListGatewaySlb", "mse", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListGatewaySlbResponse creates a response to parse from ListGatewaySlb response
func CreateListGatewaySlbResponse() (response *ListGatewaySlbResponse) {
	response = &ListGatewaySlbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
