package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteContactBlockList invokes the outboundbot.DeleteContactBlockList API synchronously
func (client *Client) DeleteContactBlockList(request *DeleteContactBlockListRequest) (response *DeleteContactBlockListResponse, err error) {
	response = CreateDeleteContactBlockListResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteContactBlockListWithChan invokes the outboundbot.DeleteContactBlockList API asynchronously
func (client *Client) DeleteContactBlockListWithChan(request *DeleteContactBlockListRequest) (<-chan *DeleteContactBlockListResponse, <-chan error) {
	responseChan := make(chan *DeleteContactBlockListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteContactBlockList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteContactBlockListWithCallback invokes the outboundbot.DeleteContactBlockList API asynchronously
func (client *Client) DeleteContactBlockListWithCallback(request *DeleteContactBlockListRequest, callback func(response *DeleteContactBlockListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteContactBlockListResponse
		var err error
		defer close(result)
		response, err = client.DeleteContactBlockList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteContactBlockListRequest is the request struct for api DeleteContactBlockList
type DeleteContactBlockListRequest struct {
	*requests.RpcRequest
	ContactBlockListId string `position:"Query" name:"ContactBlockListId"`
	Operator           string `position:"Query" name:"Operator"`
	InstanceId         string `position:"Query" name:"InstanceId"`
}

// DeleteContactBlockListResponse is the response struct for api DeleteContactBlockList
type DeleteContactBlockListResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	AffectedRows   int    `json:"AffectedRows" xml:"AffectedRows"`
}

// CreateDeleteContactBlockListRequest creates a request to invoke DeleteContactBlockList API
func CreateDeleteContactBlockListRequest() (request *DeleteContactBlockListRequest) {
	request = &DeleteContactBlockListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DeleteContactBlockList", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteContactBlockListResponse creates a response to parse from DeleteContactBlockList response
func CreateDeleteContactBlockListResponse() (response *DeleteContactBlockListResponse) {
	response = &DeleteContactBlockListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
