package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConversationList invokes the ccc.GetConversationList API synchronously
func (client *Client) GetConversationList(request *GetConversationListRequest) (response *GetConversationListResponse, err error) {
	response = CreateGetConversationListResponse()
	err = client.DoAction(request, response)
	return
}

// GetConversationListWithChan invokes the ccc.GetConversationList API asynchronously
func (client *Client) GetConversationListWithChan(request *GetConversationListRequest) (<-chan *GetConversationListResponse, <-chan error) {
	responseChan := make(chan *GetConversationListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConversationList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConversationListWithCallback invokes the ccc.GetConversationList API asynchronously
func (client *Client) GetConversationListWithCallback(request *GetConversationListRequest, callback func(response *GetConversationListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConversationListResponse
		var err error
		defer close(result)
		response, err = client.GetConversationList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConversationListRequest is the request struct for api GetConversationList
type GetConversationListRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	TaskId     string `position:"Query" name:"TaskId"`
}

// GetConversationListResponse is the response struct for api GetConversationList
type GetConversationListResponse struct {
	*responses.BaseResponse
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	Success        bool                 `json:"Success" xml:"Success"`
	Code           string               `json:"Code" xml:"Code"`
	Message        string               `json:"Message" xml:"Message"`
	HttpStatusCode int                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Conversations  []ConversationDetail `json:"Conversations" xml:"Conversations"`
}

// CreateGetConversationListRequest creates a request to invoke GetConversationList API
func CreateGetConversationListRequest() (request *GetConversationListRequest) {
	request = &GetConversationListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "GetConversationList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConversationListResponse creates a response to parse from GetConversationList response
func CreateGetConversationListResponse() (response *GetConversationListResponse) {
	response = &GetConversationListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
