package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTrunkProviders invokes the ccc.ListTrunkProviders API synchronously
func (client *Client) ListTrunkProviders(request *ListTrunkProvidersRequest) (response *ListTrunkProvidersResponse, err error) {
	response = CreateListTrunkProvidersResponse()
	err = client.DoAction(request, response)
	return
}

// ListTrunkProvidersWithChan invokes the ccc.ListTrunkProviders API asynchronously
func (client *Client) ListTrunkProvidersWithChan(request *ListTrunkProvidersRequest) (<-chan *ListTrunkProvidersResponse, <-chan error) {
	responseChan := make(chan *ListTrunkProvidersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTrunkProviders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTrunkProvidersWithCallback invokes the ccc.ListTrunkProviders API asynchronously
func (client *Client) ListTrunkProvidersWithCallback(request *ListTrunkProvidersRequest, callback func(response *ListTrunkProvidersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTrunkProvidersResponse
		var err error
		defer close(result)
		response, err = client.ListTrunkProviders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTrunkProvidersRequest is the request struct for api ListTrunkProviders
type ListTrunkProvidersRequest struct {
	*requests.RpcRequest
}

// ListTrunkProvidersResponse is the response struct for api ListTrunkProviders
type ListTrunkProvidersResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	Success        bool            `json:"Success" xml:"Success"`
	Code           string          `json:"Code" xml:"Code"`
	Message        string          `json:"Message" xml:"Message"`
	HttpStatusCode int             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	TrunkProviders []TrunkProvider `json:"TrunkProviders" xml:"TrunkProviders"`
}

// CreateListTrunkProvidersRequest creates a request to invoke ListTrunkProviders API
func CreateListTrunkProvidersRequest() (request *ListTrunkProvidersRequest) {
	request = &ListTrunkProvidersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "ListTrunkProviders", "", "")
	request.Method = requests.POST
	return
}

// CreateListTrunkProvidersResponse creates a response to parse from ListTrunkProviders response
func CreateListTrunkProvidersResponse() (response *ListTrunkProvidersResponse) {
	response = &ListTrunkProvidersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
