package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSmsDetail invokes the cloudauth.DescribeSmsDetail API synchronously
func (client *Client) DescribeSmsDetail(request *DescribeSmsDetailRequest) (response *DescribeSmsDetailResponse, err error) {
	response = CreateDescribeSmsDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSmsDetailWithChan invokes the cloudauth.DescribeSmsDetail API asynchronously
func (client *Client) DescribeSmsDetailWithChan(request *DescribeSmsDetailRequest) (<-chan *DescribeSmsDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeSmsDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSmsDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSmsDetailWithCallback invokes the cloudauth.DescribeSmsDetail API asynchronously
func (client *Client) DescribeSmsDetailWithCallback(request *DescribeSmsDetailRequest, callback func(response *DescribeSmsDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSmsDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeSmsDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSmsDetailRequest is the request struct for api DescribeSmsDetail
type DescribeSmsDetailRequest struct {
	*requests.RpcRequest
	SendStatus   string           `position:"Body" name:"SendStatus"`
	Mobile       string           `position:"Body" name:"Mobile"`
	CurrentPage  requests.Integer `position:"Body" name:"CurrentPage"`
	OuterOrderNo string           `position:"Body" name:"OuterOrderNo"`
	SignName     string           `position:"Body" name:"SignName"`
	SendDate     string           `position:"Body" name:"SendDate"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	BizId        string           `position:"Body" name:"BizId"`
	TemplateCode string           `position:"Body" name:"TemplateCode"`
	ErrorCode    string           `position:"Body" name:"ErrorCode"`
}

// DescribeSmsDetailResponse is the response struct for api DescribeSmsDetail
type DescribeSmsDetailResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Message     string      `json:"Message" xml:"Message"`
	Code        string      `json:"Code" xml:"Code"`
	TotalItem   int         `json:"TotalItem" xml:"TotalItem"`
	TotalPage   int         `json:"TotalPage" xml:"TotalPage"`
	CurrentPage int         `json:"CurrentPage" xml:"CurrentPage"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	Items       []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribeSmsDetailRequest creates a request to invoke DescribeSmsDetail API
func CreateDescribeSmsDetailRequest() (request *DescribeSmsDetailRequest) {
	request = &DescribeSmsDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2020-06-18", "DescribeSmsDetail", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSmsDetailResponse creates a response to parse from DescribeSmsDetail response
func CreateDescribeSmsDetailResponse() (response *DescribeSmsDetailResponse) {
	response = &DescribeSmsDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
