package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryIntentionList invokes the companyreg.QueryIntentionList API synchronously
func (client *Client) QueryIntentionList(request *QueryIntentionListRequest) (response *QueryIntentionListResponse, err error) {
	response = CreateQueryIntentionListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryIntentionListWithChan invokes the companyreg.QueryIntentionList API asynchronously
func (client *Client) QueryIntentionListWithChan(request *QueryIntentionListRequest) (<-chan *QueryIntentionListResponse, <-chan error) {
	responseChan := make(chan *QueryIntentionListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryIntentionList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryIntentionListWithCallback invokes the companyreg.QueryIntentionList API asynchronously
func (client *Client) QueryIntentionListWithCallback(request *QueryIntentionListRequest, callback func(response *QueryIntentionListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryIntentionListResponse
		var err error
		defer close(result)
		response, err = client.QueryIntentionList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryIntentionListRequest is the request struct for api QueryIntentionList
type QueryIntentionListRequest struct {
	*requests.RpcRequest
	TypeList  string           `position:"Query" name:"TypeList"`
	Type      requests.Integer `position:"Query" name:"Type"`
	PageNum   requests.Integer `position:"Query" name:"PageNum"`
	SortFiled string           `position:"Query" name:"SortFiled"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	SortOrder string           `position:"Query" name:"SortOrder"`
	Status    requests.Integer `position:"Query" name:"Status"`
}

// QueryIntentionListResponse is the response struct for api QueryIntentionList
type QueryIntentionListResponse struct {
	*responses.BaseResponse
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int         `json:"TotalItemNum" xml:"TotalItemNum"`
	CurrentPageNum int         `json:"CurrentPageNum" xml:"CurrentPageNum"`
	PageSize       int         `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int         `json:"TotalPageNum" xml:"TotalPageNum"`
	Data           []Intention `json:"Data" xml:"Data"`
}

// CreateQueryIntentionListRequest creates a request to invoke QueryIntentionList API
func CreateQueryIntentionListRequest() (request *QueryIntentionListRequest) {
	request = &QueryIntentionListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "QueryIntentionList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryIntentionListResponse creates a response to parse from QueryIntentionList response
func CreateQueryIntentionListResponse() (response *QueryIntentionListResponse) {
	response = &QueryIntentionListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
