package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadIcpBasicMaterial invokes the companyreg.UploadIcpBasicMaterial API synchronously
func (client *Client) UploadIcpBasicMaterial(request *UploadIcpBasicMaterialRequest) (response *UploadIcpBasicMaterialResponse, err error) {
	response = CreateUploadIcpBasicMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// UploadIcpBasicMaterialWithChan invokes the companyreg.UploadIcpBasicMaterial API asynchronously
func (client *Client) UploadIcpBasicMaterialWithChan(request *UploadIcpBasicMaterialRequest) (<-chan *UploadIcpBasicMaterialResponse, <-chan error) {
	responseChan := make(chan *UploadIcpBasicMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadIcpBasicMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadIcpBasicMaterialWithCallback invokes the companyreg.UploadIcpBasicMaterial API asynchronously
func (client *Client) UploadIcpBasicMaterialWithCallback(request *UploadIcpBasicMaterialRequest, callback func(response *UploadIcpBasicMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadIcpBasicMaterialResponse
		var err error
		defer close(result)
		response, err = client.UploadIcpBasicMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadIcpBasicMaterialRequest is the request struct for api UploadIcpBasicMaterial
type UploadIcpBasicMaterialRequest struct {
	*requests.RpcRequest
	SocialCreditCode string `position:"Query" name:"SocialCreditCode"`
	BusinessLicense  string `position:"Query" name:"BusinessLicense"`
	CorporateIdCard  string `position:"Query" name:"CorporateIdCard"`
	IdCardList       string `position:"Query" name:"IdCardList"`
	CompanyAddress   string `position:"Query" name:"CompanyAddress"`
	CompanyName      string `position:"Query" name:"CompanyName"`
	BizId            string `position:"Query" name:"BizId"`
	CorporateName    string `position:"Query" name:"CorporateName"`
}

// UploadIcpBasicMaterialResponse is the response struct for api UploadIcpBasicMaterial
type UploadIcpBasicMaterialResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUploadIcpBasicMaterialRequest creates a request to invoke UploadIcpBasicMaterial API
func CreateUploadIcpBasicMaterialRequest() (request *UploadIcpBasicMaterialRequest) {
	request = &UploadIcpBasicMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "UploadIcpBasicMaterial", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadIcpBasicMaterialResponse creates a response to parse from UploadIcpBasicMaterial response
func CreateUploadIcpBasicMaterialResponse() (response *UploadIcpBasicMaterialResponse) {
	response = &UploadIcpBasicMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
