package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnEsExecuteData invokes the dcdn.DescribeDcdnEsExecuteData API synchronously
func (client *Client) DescribeDcdnEsExecuteData(request *DescribeDcdnEsExecuteDataRequest) (response *DescribeDcdnEsExecuteDataResponse, err error) {
	response = CreateDescribeDcdnEsExecuteDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnEsExecuteDataWithChan invokes the dcdn.DescribeDcdnEsExecuteData API asynchronously
func (client *Client) DescribeDcdnEsExecuteDataWithChan(request *DescribeDcdnEsExecuteDataRequest) (<-chan *DescribeDcdnEsExecuteDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnEsExecuteDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnEsExecuteData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnEsExecuteDataWithCallback invokes the dcdn.DescribeDcdnEsExecuteData API asynchronously
func (client *Client) DescribeDcdnEsExecuteDataWithCallback(request *DescribeDcdnEsExecuteDataRequest, callback func(response *DescribeDcdnEsExecuteDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnEsExecuteDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnEsExecuteData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnEsExecuteDataRequest is the request struct for api DescribeDcdnEsExecuteData
type DescribeDcdnEsExecuteDataRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	RuleId    string           `position:"Query" name:"RuleId"`
}

// DescribeDcdnEsExecuteDataResponse is the response struct for api DescribeDcdnEsExecuteData
type DescribeDcdnEsExecuteDataResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Contents  []Content `json:"Contents" xml:"Contents"`
}

// CreateDescribeDcdnEsExecuteDataRequest creates a request to invoke DescribeDcdnEsExecuteData API
func CreateDescribeDcdnEsExecuteDataRequest() (request *DescribeDcdnEsExecuteDataRequest) {
	request = &DescribeDcdnEsExecuteDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnEsExecuteData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnEsExecuteDataResponse creates a response to parse from DescribeDcdnEsExecuteData response
func CreateDescribeDcdnEsExecuteDataResponse() (response *DescribeDcdnEsExecuteDataResponse) {
	response = &DescribeDcdnEsExecuteDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
