package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEnvHttpTrafficControl invokes the edas.DeleteEnvHttpTrafficControl API synchronously
func (client *Client) DeleteEnvHttpTrafficControl(request *DeleteEnvHttpTrafficControlRequest) (response *DeleteEnvHttpTrafficControlResponse, err error) {
	response = CreateDeleteEnvHttpTrafficControlResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEnvHttpTrafficControlWithChan invokes the edas.DeleteEnvHttpTrafficControl API asynchronously
func (client *Client) DeleteEnvHttpTrafficControlWithChan(request *DeleteEnvHttpTrafficControlRequest) (<-chan *DeleteEnvHttpTrafficControlResponse, <-chan error) {
	responseChan := make(chan *DeleteEnvHttpTrafficControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEnvHttpTrafficControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEnvHttpTrafficControlWithCallback invokes the edas.DeleteEnvHttpTrafficControl API asynchronously
func (client *Client) DeleteEnvHttpTrafficControlWithCallback(request *DeleteEnvHttpTrafficControlRequest, callback func(response *DeleteEnvHttpTrafficControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEnvHttpTrafficControlResponse
		var err error
		defer close(result)
		response, err = client.DeleteEnvHttpTrafficControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEnvHttpTrafficControlRequest is the request struct for api DeleteEnvHttpTrafficControl
type DeleteEnvHttpTrafficControlRequest struct {
	*requests.RoaRequest
	LabelAdviceName string `position:"Query" name:"LabelAdviceName"`
	PointcutName    string `position:"Query" name:"PointcutName"`
}

// DeleteEnvHttpTrafficControlResponse is the response struct for api DeleteEnvHttpTrafficControl
type DeleteEnvHttpTrafficControlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteEnvHttpTrafficControlRequest creates a request to invoke DeleteEnvHttpTrafficControl API
func CreateDeleteEnvHttpTrafficControlRequest() (request *DeleteEnvHttpTrafficControlRequest) {
	request = &DeleteEnvHttpTrafficControlRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteEnvHttpTrafficControl", "/pop/v5/gray/env_http_traffic_control", "edas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteEnvHttpTrafficControlResponse creates a response to parse from DeleteEnvHttpTrafficControl response
func CreateDeleteEnvHttpTrafficControlResponse() (response *DeleteEnvHttpTrafficControlResponse) {
	response = &DeleteEnvHttpTrafficControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
