package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGrayAppGroup invokes the edas.GetGrayAppGroup API synchronously
func (client *Client) GetGrayAppGroup(request *GetGrayAppGroupRequest) (response *GetGrayAppGroupResponse, err error) {
	response = CreateGetGrayAppGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetGrayAppGroupWithChan invokes the edas.GetGrayAppGroup API asynchronously
func (client *Client) GetGrayAppGroupWithChan(request *GetGrayAppGroupRequest) (<-chan *GetGrayAppGroupResponse, <-chan error) {
	responseChan := make(chan *GetGrayAppGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGrayAppGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGrayAppGroupWithCallback invokes the edas.GetGrayAppGroup API asynchronously
func (client *Client) GetGrayAppGroupWithCallback(request *GetGrayAppGroupRequest, callback func(response *GetGrayAppGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGrayAppGroupResponse
		var err error
		defer close(result)
		response, err = client.GetGrayAppGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGrayAppGroupRequest is the request struct for api GetGrayAppGroup
type GetGrayAppGroupRequest struct {
	*requests.RoaRequest
	AppIds          string `position:"Query" name:"AppIds"`
	LogicalRegionId string `position:"Query" name:"LogicalRegionId"`
	PointcutName    string `position:"Query" name:"PointcutName"`
}

// GetGrayAppGroupResponse is the response struct for api GetGrayAppGroup
type GetGrayAppGroupResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetGrayAppGroupRequest creates a request to invoke GetGrayAppGroup API
func CreateGetGrayAppGroupRequest() (request *GetGrayAppGroupRequest) {
	request = &GetGrayAppGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetGrayAppGroup", "/pop/v5/gray/app_group_list", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetGrayAppGroupResponse creates a response to parse from GetGrayAppGroup response
func CreateGetGrayAppGroupResponse() (response *GetGrayAppGroupResponse) {
	response = &GetGrayAppGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
