package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopCollector invokes the elasticsearch.StopCollector API synchronously
func (client *Client) StopCollector(request *StopCollectorRequest) (response *StopCollectorResponse, err error) {
	response = CreateStopCollectorResponse()
	err = client.DoAction(request, response)
	return
}

// StopCollectorWithChan invokes the elasticsearch.StopCollector API asynchronously
func (client *Client) StopCollectorWithChan(request *StopCollectorRequest) (<-chan *StopCollectorResponse, <-chan error) {
	responseChan := make(chan *StopCollectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopCollector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopCollectorWithCallback invokes the elasticsearch.StopCollector API asynchronously
func (client *Client) StopCollectorWithCallback(request *StopCollectorRequest, callback func(response *StopCollectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopCollectorResponse
		var err error
		defer close(result)
		response, err = client.StopCollector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopCollectorRequest is the request struct for api StopCollector
type StopCollectorRequest struct {
	*requests.RoaRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	ResId       string `position:"Path" name:"ResId"`
}

// StopCollectorResponse is the response struct for api StopCollector
type StopCollectorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateStopCollectorRequest creates a request to invoke StopCollector API
func CreateStopCollectorRequest() (request *StopCollectorRequest) {
	request = &StopCollectorRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "StopCollector", "/openapi/collectors/[ResId]/actions/stop", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopCollectorResponse creates a response to parse from StopCollector response
func CreateStopCollectorResponse() (response *StopCollectorResponse) {
	response = &StopCollectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
