package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePdnsAppKeys invokes the alidns.DescribePdnsAppKeys API synchronously
func (client *Client) DescribePdnsAppKeys(request *DescribePdnsAppKeysRequest) (response *DescribePdnsAppKeysResponse, err error) {
	response = CreateDescribePdnsAppKeysResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePdnsAppKeysWithChan invokes the alidns.DescribePdnsAppKeys API asynchronously
func (client *Client) DescribePdnsAppKeysWithChan(request *DescribePdnsAppKeysRequest) (<-chan *DescribePdnsAppKeysResponse, <-chan error) {
	responseChan := make(chan *DescribePdnsAppKeysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePdnsAppKeys(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePdnsAppKeysWithCallback invokes the alidns.DescribePdnsAppKeys API asynchronously
func (client *Client) DescribePdnsAppKeysWithCallback(request *DescribePdnsAppKeysRequest, callback func(response *DescribePdnsAppKeysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePdnsAppKeysResponse
		var err error
		defer close(result)
		response, err = client.DescribePdnsAppKeys(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePdnsAppKeysRequest is the request struct for api DescribePdnsAppKeys
type DescribePdnsAppKeysRequest struct {
	*requests.RpcRequest
	Lang string `position:"Query" name:"Lang"`
}

// DescribePdnsAppKeysResponse is the response struct for api DescribePdnsAppKeys
type DescribePdnsAppKeysResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	AppKeys   []AppKey `json:"AppKeys" xml:"AppKeys"`
}

// CreateDescribePdnsAppKeysRequest creates a request to invoke DescribePdnsAppKeys API
func CreateDescribePdnsAppKeysRequest() (request *DescribePdnsAppKeysRequest) {
	request = &DescribePdnsAppKeysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribePdnsAppKeys", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePdnsAppKeysResponse creates a response to parse from DescribePdnsAppKeys response
func CreateDescribePdnsAppKeysResponse() (response *DescribePdnsAppKeysResponse) {
	response = &DescribePdnsAppKeysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
