package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOssSts invokes the companyreg.GetOssSts API synchronously
func (client *Client) GetOssSts(request *GetOssStsRequest) (response *GetOssStsResponse, err error) {
	response = CreateGetOssStsResponse()
	err = client.DoAction(request, response)
	return
}

// GetOssStsWithChan invokes the companyreg.GetOssSts API asynchronously
func (client *Client) GetOssStsWithChan(request *GetOssStsRequest) (<-chan *GetOssStsResponse, <-chan error) {
	responseChan := make(chan *GetOssStsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOssSts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOssStsWithCallback invokes the companyreg.GetOssSts API asynchronously
func (client *Client) GetOssStsWithCallback(request *GetOssStsRequest, callback func(response *GetOssStsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOssStsResponse
		var err error
		defer close(result)
		response, err = client.GetOssSts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOssStsRequest is the request struct for api GetOssSts
type GetOssStsRequest struct {
	*requests.RpcRequest
	OssKey string `position:"Query" name:"OssKey"`
	BizId  string `position:"Query" name:"BizId"`
}

// GetOssStsResponse is the response struct for api GetOssSts
type GetOssStsResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	AccessId      string `json:"AccessId" xml:"AccessId"`
	EncodedPolicy string `json:"EncodedPolicy" xml:"EncodedPolicy"`
	Signature     string `json:"Signature" xml:"Signature"`
	FilePath      string `json:"FilePath" xml:"FilePath"`
	ExpireTime    int64  `json:"ExpireTime" xml:"ExpireTime"`
	Host          string `json:"Host" xml:"Host"`
	OssHost       string `json:"OssHost" xml:"OssHost"`
}

// CreateGetOssStsRequest creates a request to invoke GetOssSts API
func CreateGetOssStsRequest() (request *GetOssStsRequest) {
	request = &GetOssStsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetOssSts", "", "")
	request.Method = requests.GET
	return
}

// CreateGetOssStsResponse creates a response to parse from GetOssSts response
func CreateGetOssStsResponse() (response *GetOssStsResponse) {
	response = &GetOssStsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
