package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMetaTableIntroWiki invokes the dataworks_public.UpdateMetaTableIntroWiki API synchronously
func (client *Client) UpdateMetaTableIntroWiki(request *UpdateMetaTableIntroWikiRequest) (response *UpdateMetaTableIntroWikiResponse, err error) {
	response = CreateUpdateMetaTableIntroWikiResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMetaTableIntroWikiWithChan invokes the dataworks_public.UpdateMetaTableIntroWiki API asynchronously
func (client *Client) UpdateMetaTableIntroWikiWithChan(request *UpdateMetaTableIntroWikiRequest) (<-chan *UpdateMetaTableIntroWikiResponse, <-chan error) {
	responseChan := make(chan *UpdateMetaTableIntroWikiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMetaTableIntroWiki(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMetaTableIntroWikiWithCallback invokes the dataworks_public.UpdateMetaTableIntroWiki API asynchronously
func (client *Client) UpdateMetaTableIntroWikiWithCallback(request *UpdateMetaTableIntroWikiRequest, callback func(response *UpdateMetaTableIntroWikiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMetaTableIntroWikiResponse
		var err error
		defer close(result)
		response, err = client.UpdateMetaTableIntroWiki(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMetaTableIntroWikiRequest is the request struct for api UpdateMetaTableIntroWiki
type UpdateMetaTableIntroWikiRequest struct {
	*requests.RpcRequest
	TableGuid string `position:"Query" name:"TableGuid"`
	Content   string `position:"Body" name:"Content"`
}

// UpdateMetaTableIntroWikiResponse is the response struct for api UpdateMetaTableIntroWiki
type UpdateMetaTableIntroWikiResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	UpdateResult bool   `json:"UpdateResult" xml:"UpdateResult"`
}

// CreateUpdateMetaTableIntroWikiRequest creates a request to invoke UpdateMetaTableIntroWiki API
func CreateUpdateMetaTableIntroWikiRequest() (request *UpdateMetaTableIntroWikiRequest) {
	request = &UpdateMetaTableIntroWikiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateMetaTableIntroWiki", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateMetaTableIntroWikiResponse creates a response to parse from UpdateMetaTableIntroWiki response
func CreateUpdateMetaTableIntroWikiResponse() (response *UpdateMetaTableIntroWikiResponse) {
	response = &UpdateMetaTableIntroWikiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
