package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPagePerfTrend invokes the emas_appmonitor.QueryPagePerfTrend API synchronously
func (client *Client) QueryPagePerfTrend(request *QueryPagePerfTrendRequest) (response *QueryPagePerfTrendResponse, err error) {
	response = CreateQueryPagePerfTrendResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPagePerfTrendWithChan invokes the emas_appmonitor.QueryPagePerfTrend API asynchronously
func (client *Client) QueryPagePerfTrendWithChan(request *QueryPagePerfTrendRequest) (<-chan *QueryPagePerfTrendResponse, <-chan error) {
	responseChan := make(chan *QueryPagePerfTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPagePerfTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPagePerfTrendWithCallback invokes the emas_appmonitor.QueryPagePerfTrend API asynchronously
func (client *Client) QueryPagePerfTrendWithCallback(request *QueryPagePerfTrendRequest, callback func(response *QueryPagePerfTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPagePerfTrendResponse
		var err error
		defer close(result)
		response, err = client.QueryPagePerfTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPagePerfTrendRequest is the request struct for api QueryPagePerfTrend
type QueryPagePerfTrendRequest struct {
	*requests.RpcRequest
	MetricType         string           `position:"Body" name:"MetricType"`
	AppVersionStrategy string           `position:"Body" name:"AppVersionStrategy"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	DeviceLevel        string           `position:"Body" name:"DeviceLevel"`
	Province           *[]string        `position:"Body" name:"Province"  type:"Repeated"`
	StatType           string           `position:"Body" name:"StatType"`
	IntervalMinutes    requests.Integer `position:"Body" name:"IntervalMinutes"`
	UniqueAppId        string           `position:"Body" name:"UniqueAppId"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	AppVersion         *[]string        `position:"Body" name:"AppVersion"  type:"Repeated"`
	Page               *[]string        `position:"Body" name:"Page"  type:"Repeated"`
}

// QueryPagePerfTrendResponse is the response struct for api QueryPagePerfTrend
type QueryPagePerfTrendResponse struct {
	*responses.BaseResponse
	RequestId        string             `json:"RequestId" xml:"RequestId"`
	MetricResultList []MetricResultItem `json:"MetricResultList" xml:"MetricResultList"`
}

// CreateQueryPagePerfTrendRequest creates a request to invoke QueryPagePerfTrend API
func CreateQueryPagePerfTrendRequest() (request *QueryPagePerfTrendRequest) {
	request = &QueryPagePerfTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "QueryPagePerfTrend", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryPagePerfTrendResponse creates a response to parse from QueryPagePerfTrend response
func CreateQueryPagePerfTrendResponse() (response *QueryPagePerfTrendResponse) {
	response = &QueryPagePerfTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
