package goodstech

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ClassifyCommodity invokes the goodstech.ClassifyCommodity API synchronously
func (client *Client) ClassifyCommodity(request *ClassifyCommodityRequest) (response *ClassifyCommodityResponse, err error) {
	response = CreateClassifyCommodityResponse()
	err = client.DoAction(request, response)
	return
}

// ClassifyCommodityWithChan invokes the goodstech.ClassifyCommodity API asynchronously
func (client *Client) ClassifyCommodityWithChan(request *ClassifyCommodityRequest) (<-chan *ClassifyCommodityResponse, <-chan error) {
	responseChan := make(chan *ClassifyCommodityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ClassifyCommodity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ClassifyCommodityWithCallback invokes the goodstech.ClassifyCommodity API asynchronously
func (client *Client) ClassifyCommodityWithCallback(request *ClassifyCommodityRequest, callback func(response *ClassifyCommodityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ClassifyCommodityResponse
		var err error
		defer close(result)
		response, err = client.ClassifyCommodity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ClassifyCommodityRequest is the request struct for api ClassifyCommodity
type ClassifyCommodityRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Query" name:"ImageURL"`
}

// ClassifyCommodityResponse is the response struct for api ClassifyCommodity
type ClassifyCommodityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateClassifyCommodityRequest creates a request to invoke ClassifyCommodity API
func CreateClassifyCommodityRequest() (request *ClassifyCommodityRequest) {
	request = &ClassifyCommodityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("goodstech", "2019-12-30", "ClassifyCommodity", "goodstech", "openAPI")
	request.Method = requests.POST
	return
}

// CreateClassifyCommodityResponse creates a response to parse from ClassifyCommodity response
func CreateClassifyCommodityResponse() (response *ClassifyCommodityResponse) {
	response = &ClassifyCommodityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
