package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSpecification invokes the gpdb.DescribeSpecification API synchronously
func (client *Client) DescribeSpecification(request *DescribeSpecificationRequest) (response *DescribeSpecificationResponse, err error) {
	response = CreateDescribeSpecificationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSpecificationWithChan invokes the gpdb.DescribeSpecification API asynchronously
func (client *Client) DescribeSpecificationWithChan(request *DescribeSpecificationRequest) (<-chan *DescribeSpecificationResponse, <-chan error) {
	responseChan := make(chan *DescribeSpecificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSpecification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSpecificationWithCallback invokes the gpdb.DescribeSpecification API asynchronously
func (client *Client) DescribeSpecificationWithCallback(request *DescribeSpecificationRequest, callback func(response *DescribeSpecificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSpecificationResponse
		var err error
		defer close(result)
		response, err = client.DescribeSpecification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSpecificationRequest is the request struct for api DescribeSpecification
type DescribeSpecificationRequest struct {
	*requests.RpcRequest
	StorageType  string           `position:"Query" name:"StorageType"`
	CpuCores     requests.Integer `position:"Query" name:"CpuCores"`
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	TotalNodeNum requests.Integer `position:"Query" name:"TotalNodeNum"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeSpecificationResponse is the response struct for api DescribeSpecification
type DescribeSpecificationResponse struct {
	*responses.BaseResponse
	RequestId            string                     `json:"RequestId" xml:"RequestId"`
	StorageNotice        []StorageNoticeItem        `json:"StorageNotice" xml:"StorageNotice"`
	DBInstanceClass      []DBInstanceClassItem      `json:"DBInstanceClass" xml:"DBInstanceClass"`
	DBInstanceGroupCount []DBInstanceGroupCountItem `json:"DBInstanceGroupCount" xml:"DBInstanceGroupCount"`
}

// CreateDescribeSpecificationRequest creates a request to invoke DescribeSpecification API
func CreateDescribeSpecificationRequest() (request *DescribeSpecificationRequest) {
	request = &DescribeSpecificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeSpecification", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSpecificationResponse creates a response to parse from DescribeSpecification response
func CreateDescribeSpecificationResponse() (response *DescribeSpecificationResponse) {
	response = &DescribeSpecificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
