package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddAuthResource invokes the mse.AddAuthResource API synchronously
func (client *Client) AddAuthResource(request *AddAuthResourceRequest) (response *AddAuthResourceResponse, err error) {
	response = CreateAddAuthResourceResponse()
	err = client.DoAction(request, response)
	return
}

// AddAuthResourceWithChan invokes the mse.AddAuthResource API asynchronously
func (client *Client) AddAuthResourceWithChan(request *AddAuthResourceRequest) (<-chan *AddAuthResourceResponse, <-chan error) {
	responseChan := make(chan *AddAuthResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddAuthResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddAuthResourceWithCallback invokes the mse.AddAuthResource API asynchronously
func (client *Client) AddAuthResourceWithCallback(request *AddAuthResourceRequest, callback func(response *AddAuthResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddAuthResourceResponse
		var err error
		defer close(result)
		response, err = client.AddAuthResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddAuthResourceRequest is the request struct for api AddAuthResource
type AddAuthResourceRequest struct {
	*requests.RpcRequest
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	AuthId          requests.Integer `position:"Query" name:"AuthId"`
	DomainId        requests.Integer `position:"Query" name:"DomainId"`
	Path            string           `position:"Query" name:"Path"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// AddAuthResourceResponse is the response struct for api AddAuthResource
type AddAuthResourceResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateAddAuthResourceRequest creates a request to invoke AddAuthResource API
func CreateAddAuthResourceRequest() (request *AddAuthResourceRequest) {
	request = &AddAuthResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddAuthResource", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddAuthResourceResponse creates a response to parse from AddAuthResource response
func CreateAddAuthResourceResponse() (response *AddAuthResourceResponse) {
	response = &AddAuthResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
