package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetKubernetesSource invokes the mse.GetKubernetesSource API synchronously
func (client *Client) GetKubernetesSource(request *GetKubernetesSourceRequest) (response *GetKubernetesSourceResponse, err error) {
	response = CreateGetKubernetesSourceResponse()
	err = client.DoAction(request, response)
	return
}

// GetKubernetesSourceWithChan invokes the mse.GetKubernetesSource API asynchronously
func (client *Client) GetKubernetesSourceWithChan(request *GetKubernetesSourceRequest) (<-chan *GetKubernetesSourceResponse, <-chan error) {
	responseChan := make(chan *GetKubernetesSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetKubernetesSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetKubernetesSourceWithCallback invokes the mse.GetKubernetesSource API asynchronously
func (client *Client) GetKubernetesSourceWithCallback(request *GetKubernetesSourceRequest, callback func(response *GetKubernetesSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetKubernetesSourceResponse
		var err error
		defer close(result)
		response, err = client.GetKubernetesSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetKubernetesSourceRequest is the request struct for api GetKubernetesSource
type GetKubernetesSourceRequest struct {
	*requests.RpcRequest
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// GetKubernetesSourceResponse is the response struct for api GetKubernetesSource
type GetKubernetesSourceResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string       `json:"Message" xml:"Message"`
	Code           int          `json:"Code" xml:"Code"`
	Success        bool         `json:"Success" xml:"Success"`
	Data           []K8sSources `json:"Data" xml:"Data"`
}

// CreateGetKubernetesSourceRequest creates a request to invoke GetKubernetesSource API
func CreateGetKubernetesSourceRequest() (request *GetKubernetesSourceRequest) {
	request = &GetKubernetesSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetKubernetesSource", "mse", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetKubernetesSourceResponse creates a response to parse from GetKubernetesSource response
func CreateGetKubernetesSourceResponse() (response *GetKubernetesSourceResponse) {
	response = &GetKubernetesSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
