package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayBlockVolumes invokes the sgw.DescribeGatewayBlockVolumes API synchronously
func (client *Client) DescribeGatewayBlockVolumes(request *DescribeGatewayBlockVolumesRequest) (response *DescribeGatewayBlockVolumesResponse, err error) {
	response = CreateDescribeGatewayBlockVolumesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayBlockVolumesWithChan invokes the sgw.DescribeGatewayBlockVolumes API asynchronously
func (client *Client) DescribeGatewayBlockVolumesWithChan(request *DescribeGatewayBlockVolumesRequest) (<-chan *DescribeGatewayBlockVolumesResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayBlockVolumesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayBlockVolumes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayBlockVolumesWithCallback invokes the sgw.DescribeGatewayBlockVolumes API asynchronously
func (client *Client) DescribeGatewayBlockVolumesWithCallback(request *DescribeGatewayBlockVolumesRequest, callback func(response *DescribeGatewayBlockVolumesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayBlockVolumesResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayBlockVolumes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayBlockVolumesRequest is the request struct for api DescribeGatewayBlockVolumes
type DescribeGatewayBlockVolumesRequest struct {
	*requests.RpcRequest
	Refresh       requests.Boolean `position:"Query" name:"Refresh"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	IndexId       string           `position:"Query" name:"IndexId"`
	GatewayId     string           `position:"Query" name:"GatewayId"`
}

// DescribeGatewayBlockVolumesResponse is the response struct for api DescribeGatewayBlockVolumes
type DescribeGatewayBlockVolumesResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	BlockVolumes BlockVolumes `json:"BlockVolumes" xml:"BlockVolumes"`
}

// CreateDescribeGatewayBlockVolumesRequest creates a request to invoke DescribeGatewayBlockVolumes API
func CreateDescribeGatewayBlockVolumesRequest() (request *DescribeGatewayBlockVolumesRequest) {
	request = &DescribeGatewayBlockVolumesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayBlockVolumes", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayBlockVolumesResponse creates a response to parse from DescribeGatewayBlockVolumes response
func CreateDescribeGatewayBlockVolumesResponse() (response *DescribeGatewayBlockVolumesResponse) {
	response = &DescribeGatewayBlockVolumesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
