package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeVideoSize invokes the videoenhan.ChangeVideoSize API synchronously
func (client *Client) ChangeVideoSize(request *ChangeVideoSizeRequest) (response *ChangeVideoSizeResponse, err error) {
	response = CreateChangeVideoSizeResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeVideoSizeWithChan invokes the videoenhan.ChangeVideoSize API asynchronously
func (client *Client) ChangeVideoSizeWithChan(request *ChangeVideoSizeRequest) (<-chan *ChangeVideoSizeResponse, <-chan error) {
	responseChan := make(chan *ChangeVideoSizeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeVideoSize(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeVideoSizeWithCallback invokes the videoenhan.ChangeVideoSize API asynchronously
func (client *Client) ChangeVideoSizeWithCallback(request *ChangeVideoSizeRequest, callback func(response *ChangeVideoSizeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeVideoSizeResponse
		var err error
		defer close(result)
		response, err = client.ChangeVideoSize(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeVideoSizeRequest is the request struct for api ChangeVideoSize
type ChangeVideoSizeRequest struct {
	*requests.RpcRequest
	Height    requests.Integer `position:"Body" name:"Height"`
	B         requests.Integer `position:"Body" name:"B"`
	FillType  string           `position:"Body" name:"FillType"`
	G         requests.Integer `position:"Body" name:"G"`
	CropType  string           `position:"Body" name:"CropType"`
	Async     requests.Boolean `position:"Body" name:"Async"`
	R         requests.Integer `position:"Body" name:"R"`
	VideoUrl  string           `position:"Body" name:"VideoUrl"`
	Width     requests.Integer `position:"Body" name:"Width"`
	Tightness requests.Float   `position:"Body" name:"Tightness"`
}

// ChangeVideoSizeResponse is the response struct for api ChangeVideoSize
type ChangeVideoSizeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateChangeVideoSizeRequest creates a request to invoke ChangeVideoSize API
func CreateChangeVideoSizeRequest() (request *ChangeVideoSizeRequest) {
	request = &ChangeVideoSizeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "ChangeVideoSize", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateChangeVideoSizeResponse creates a response to parse from ChangeVideoSize response
func CreateChangeVideoSizeResponse() (response *ChangeVideoSizeResponse) {
	response = &ChangeVideoSizeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
