package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GotoPreset invokes the vs.GotoPreset API synchronously
func (client *Client) GotoPreset(request *GotoPresetRequest) (response *GotoPresetResponse, err error) {
	response = CreateGotoPresetResponse()
	err = client.DoAction(request, response)
	return
}

// GotoPresetWithChan invokes the vs.GotoPreset API asynchronously
func (client *Client) GotoPresetWithChan(request *GotoPresetRequest) (<-chan *GotoPresetResponse, <-chan error) {
	responseChan := make(chan *GotoPresetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GotoPreset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GotoPresetWithCallback invokes the vs.GotoPreset API asynchronously
func (client *Client) GotoPresetWithCallback(request *GotoPresetRequest, callback func(response *GotoPresetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GotoPresetResponse
		var err error
		defer close(result)
		response, err = client.GotoPreset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GotoPresetRequest is the request struct for api GotoPreset
type GotoPresetRequest struct {
	*requests.RpcRequest
	SubProtocol string           `position:"Query" name:"SubProtocol"`
	Id          string           `position:"Query" name:"Id"`
	PresetId    string           `position:"Query" name:"PresetId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
}

// GotoPresetResponse is the response struct for api GotoPreset
type GotoPresetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateGotoPresetRequest creates a request to invoke GotoPreset API
func CreateGotoPresetRequest() (request *GotoPresetRequest) {
	request = &GotoPresetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "GotoPreset", "", "")
	request.Method = requests.POST
	return
}

// CreateGotoPresetResponse creates a response to parse from GotoPreset response
func CreateGotoPresetResponse() (response *GotoPresetResponse) {
	response = &GotoPresetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
