package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ClearTrailData invokes the companyreg.ClearTrailData API synchronously
func (client *Client) ClearTrailData(request *ClearTrailDataRequest) (response *ClearTrailDataResponse, err error) {
	response = CreateClearTrailDataResponse()
	err = client.DoAction(request, response)
	return
}

// ClearTrailDataWithChan invokes the companyreg.ClearTrailData API asynchronously
func (client *Client) ClearTrailDataWithChan(request *ClearTrailDataRequest) (<-chan *ClearTrailDataResponse, <-chan error) {
	responseChan := make(chan *ClearTrailDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ClearTrailData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ClearTrailDataWithCallback invokes the companyreg.ClearTrailData API asynchronously
func (client *Client) ClearTrailDataWithCallback(request *ClearTrailDataRequest, callback func(response *ClearTrailDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ClearTrailDataResponse
		var err error
		defer close(result)
		response, err = client.ClearTrailData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ClearTrailDataRequest is the request struct for api ClearTrailData
type ClearTrailDataRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// ClearTrailDataResponse is the response struct for api ClearTrailData
type ClearTrailDataResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateClearTrailDataRequest creates a request to invoke ClearTrailData API
func CreateClearTrailDataRequest() (request *ClearTrailDataRequest) {
	request = &ClearTrailDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "ClearTrailData", "", "")
	request.Method = requests.GET
	return
}

// CreateClearTrailDataResponse creates a response to parse from ClearTrailData response
func CreateClearTrailDataResponse() (response *ClearTrailDataResponse) {
	response = &ClearTrailDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
