package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfirmIntention invokes the companyreg.ConfirmIntention API synchronously
func (client *Client) ConfirmIntention(request *ConfirmIntentionRequest) (response *ConfirmIntentionResponse, err error) {
	response = CreateConfirmIntentionResponse()
	err = client.DoAction(request, response)
	return
}

// ConfirmIntentionWithChan invokes the companyreg.ConfirmIntention API asynchronously
func (client *Client) ConfirmIntentionWithChan(request *ConfirmIntentionRequest) (<-chan *ConfirmIntentionResponse, <-chan error) {
	responseChan := make(chan *ConfirmIntentionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfirmIntention(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfirmIntentionWithCallback invokes the companyreg.ConfirmIntention API asynchronously
func (client *Client) ConfirmIntentionWithCallback(request *ConfirmIntentionRequest, callback func(response *ConfirmIntentionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfirmIntentionResponse
		var err error
		defer close(result)
		response, err = client.ConfirmIntention(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfirmIntentionRequest is the request struct for api ConfirmIntention
type ConfirmIntentionRequest struct {
	*requests.RpcRequest
	BizId string `position:"Body" name:"BizId"`
}

// ConfirmIntentionResponse is the response struct for api ConfirmIntention
type ConfirmIntentionResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Success    bool   `json:"Success" xml:"Success"`
	ConfirmUrl string `json:"ConfirmUrl" xml:"ConfirmUrl"`
}

// CreateConfirmIntentionRequest creates a request to invoke ConfirmIntention API
func CreateConfirmIntentionRequest() (request *ConfirmIntentionRequest) {
	request = &ConfirmIntentionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "ConfirmIntention", "", "")
	request.Method = requests.POST
	return
}

// CreateConfirmIntentionResponse creates a response to parse from ConfirmIntention response
func CreateConfirmIntentionResponse() (response *ConfirmIntentionResponse) {
	response = &ConfirmIntentionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
