package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AccessHDMInstance invokes the das.AccessHDMInstance API synchronously
func (client *Client) AccessHDMInstance(request *AccessHDMInstanceRequest) (response *AccessHDMInstanceResponse, err error) {
	response = CreateAccessHDMInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// AccessHDMInstanceWithChan invokes the das.AccessHDMInstance API asynchronously
func (client *Client) AccessHDMInstanceWithChan(request *AccessHDMInstanceRequest) (<-chan *AccessHDMInstanceResponse, <-chan error) {
	responseChan := make(chan *AccessHDMInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AccessHDMInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AccessHDMInstanceWithCallback invokes the das.AccessHDMInstance API asynchronously
func (client *Client) AccessHDMInstanceWithCallback(request *AccessHDMInstanceRequest, callback func(response *AccessHDMInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AccessHDMInstanceResponse
		var err error
		defer close(result)
		response, err = client.AccessHDMInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AccessHDMInstanceRequest is the request struct for api AccessHDMInstance
type AccessHDMInstanceRequest struct {
	*requests.RpcRequest
	SkipAuth         string `position:"Query" name:"skipAuth"`
	Signature        string `position:"Query" name:"signature"`
	NetworkType      string `position:"Query" name:"NetworkType"`
	UserId           string `position:"Query" name:"UserId"`
	CallerType       string `position:"Query" name:"CallerType"`
	Uid              string `position:"Query" name:"Uid"`
	Password         string `position:"Query" name:"Password"`
	AccessKey        string `position:"Query" name:"accessKey"`
	Engine           string `position:"Query" name:"Engine"`
	TenantId         string `position:"Query" name:"TenantId"`
	CallerUid        string `position:"Query" name:"CallerUid"`
	Timestamp        string `position:"Query" name:"timestamp"`
	Product          string `position:"Query" name:"Product"`
	Context          string `position:"Query" name:"__context"`
	Ip               string `position:"Query" name:"Ip"`
	InstanceAlias    string `position:"Query" name:"InstanceAlias"`
	CallerBid        string `position:"Query" name:"CallerBid"`
	InstanceArea     string `position:"Query" name:"InstanceArea"`
	OwnerId          string `position:"Query" name:"OwnerId"`
	Target           string `position:"Query" name:"Target"`
	External         string `position:"Query" name:"External"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	Port             string `position:"Query" name:"Port"`
	VpcId            string `position:"Query" name:"VpcId"`
	OwnerIdSignature string `position:"Query" name:"OwnerIdSignature"`
	Region           string `position:"Query" name:"Region"`
	Username         string `position:"Query" name:"Username"`
}

// AccessHDMInstanceResponse is the response struct for api AccessHDMInstance
type AccessHDMInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Synchro   string `json:"Synchro" xml:"Synchro"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateAccessHDMInstanceRequest creates a request to invoke AccessHDMInstance API
func CreateAccessHDMInstanceRequest() (request *AccessHDMInstanceRequest) {
	request = &AccessHDMInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "AccessHDMInstance", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAccessHDMInstanceResponse creates a response to parse from AccessHDMInstance response
func CreateAccessHDMInstanceResponse() (response *AccessHDMInstanceResponse) {
	response = &AccessHDMInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
