package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNodeGroup invokes the linkwan.UpdateNodeGroup API synchronously
func (client *Client) UpdateNodeGroup(request *UpdateNodeGroupRequest) (response *UpdateNodeGroupResponse, err error) {
	response = CreateUpdateNodeGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNodeGroupWithChan invokes the linkwan.UpdateNodeGroup API asynchronously
func (client *Client) UpdateNodeGroupWithChan(request *UpdateNodeGroupRequest) (<-chan *UpdateNodeGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateNodeGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNodeGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNodeGroupWithCallback invokes the linkwan.UpdateNodeGroup API asynchronously
func (client *Client) UpdateNodeGroupWithCallback(request *UpdateNodeGroupRequest, callback func(response *UpdateNodeGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNodeGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateNodeGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNodeGroupRequest is the request struct for api UpdateNodeGroup
type UpdateNodeGroupRequest struct {
	*requests.RpcRequest
	NodeGroupName string `position:"Query" name:"NodeGroupName"`
	NodeGroupId   string `position:"Query" name:"NodeGroupId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// UpdateNodeGroupResponse is the response struct for api UpdateNodeGroup
type UpdateNodeGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateNodeGroupRequest creates a request to invoke UpdateNodeGroup API
func CreateUpdateNodeGroupRequest() (request *UpdateNodeGroupRequest) {
	request = &UpdateNodeGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "UpdateNodeGroup", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateNodeGroupResponse creates a response to parse from UpdateNodeGroup response
func CreateUpdateNodeGroupResponse() (response *UpdateNodeGroupResponse) {
	response = &UpdateNodeGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
