package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDistributeTableList invokes the polardbx.DescribeDistributeTableList API synchronously
func (client *Client) DescribeDistributeTableList(request *DescribeDistributeTableListRequest) (response *DescribeDistributeTableListResponse, err error) {
	response = CreateDescribeDistributeTableListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDistributeTableListWithChan invokes the polardbx.DescribeDistributeTableList API asynchronously
func (client *Client) DescribeDistributeTableListWithChan(request *DescribeDistributeTableListRequest) (<-chan *DescribeDistributeTableListResponse, <-chan error) {
	responseChan := make(chan *DescribeDistributeTableListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDistributeTableList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDistributeTableListWithCallback invokes the polardbx.DescribeDistributeTableList API asynchronously
func (client *Client) DescribeDistributeTableListWithCallback(request *DescribeDistributeTableListRequest, callback func(response *DescribeDistributeTableListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDistributeTableListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDistributeTableList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDistributeTableListRequest is the request struct for api DescribeDistributeTableList
type DescribeDistributeTableListRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
	DbName         string `position:"Query" name:"DbName"`
}

// DescribeDistributeTableListResponse is the response struct for api DescribeDistributeTableList
type DescribeDistributeTableListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeDistributeTableListRequest creates a request to invoke DescribeDistributeTableList API
func CreateDescribeDistributeTableListRequest() (request *DescribeDistributeTableListRequest) {
	request = &DescribeDistributeTableListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeDistributeTableList", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDistributeTableListResponse creates a response to parse from DescribeDistributeTableList response
func CreateDescribeDistributeTableListResponse() (response *DescribeDistributeTableListResponse) {
	response = &DescribeDistributeTableListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
