package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserDetail invokes the vcs.GetUserDetail API synchronously
func (client *Client) GetUserDetail(request *GetUserDetailRequest) (response *GetUserDetailResponse, err error) {
	response = CreateGetUserDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserDetailWithChan invokes the vcs.GetUserDetail API asynchronously
func (client *Client) GetUserDetailWithChan(request *GetUserDetailRequest) (<-chan *GetUserDetailResponse, <-chan error) {
	responseChan := make(chan *GetUserDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserDetailWithCallback invokes the vcs.GetUserDetail API asynchronously
func (client *Client) GetUserDetailWithCallback(request *GetUserDetailRequest, callback func(response *GetUserDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserDetailResponse
		var err error
		defer close(result)
		response, err = client.GetUserDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserDetailRequest is the request struct for api GetUserDetail
type GetUserDetailRequest struct {
	*requests.RpcRequest
	IsvSubId       string           `position:"Body" name:"IsvSubId"`
	CorpId         string           `position:"Body" name:"CorpId"`
	NeedFaceDetail requests.Boolean `position:"Body" name:"NeedFaceDetail"`
	UserId         requests.Integer `position:"Body" name:"UserId"`
}

// GetUserDetailResponse is the response struct for api GetUserDetail
type GetUserDetailResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetUserDetailRequest creates a request to invoke GetUserDetail API
func CreateGetUserDetailRequest() (request *GetUserDetailRequest) {
	request = &GetUserDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "GetUserDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateGetUserDetailResponse creates a response to parse from GetUserDetail response
func CreateGetUserDetailResponse() (response *GetUserDetailResponse) {
	response = &GetUserDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
