// Code generated by protoc-gen-go. DO NOT EDIT.
// source: github.com/kubernetes-csi/csi-proxy/client/api/volume/v1alpha1/api.proto

package v1alpha1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ListVolumesOnDiskRequest struct {
	// Disk device ID of the disk to query for volumes
	DiskId               string   `protobuf:"bytes,1,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVolumesOnDiskRequest) Reset()         { *m = ListVolumesOnDiskRequest{} }
func (m *ListVolumesOnDiskRequest) String() string { return proto.CompactTextString(m) }
func (*ListVolumesOnDiskRequest) ProtoMessage()    {}
func (*ListVolumesOnDiskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{0}
}

func (m *ListVolumesOnDiskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVolumesOnDiskRequest.Unmarshal(m, b)
}
func (m *ListVolumesOnDiskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVolumesOnDiskRequest.Marshal(b, m, deterministic)
}
func (m *ListVolumesOnDiskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVolumesOnDiskRequest.Merge(m, src)
}
func (m *ListVolumesOnDiskRequest) XXX_Size() int {
	return xxx_messageInfo_ListVolumesOnDiskRequest.Size(m)
}
func (m *ListVolumesOnDiskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVolumesOnDiskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListVolumesOnDiskRequest proto.InternalMessageInfo

func (m *ListVolumesOnDiskRequest) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type ListVolumesOnDiskResponse struct {
	// Volume device IDs of volumes on the specified disk
	VolumeIds            []string `protobuf:"bytes,1,rep,name=volume_ids,json=volumeIds,proto3" json:"volume_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVolumesOnDiskResponse) Reset()         { *m = ListVolumesOnDiskResponse{} }
func (m *ListVolumesOnDiskResponse) String() string { return proto.CompactTextString(m) }
func (*ListVolumesOnDiskResponse) ProtoMessage()    {}
func (*ListVolumesOnDiskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{1}
}

func (m *ListVolumesOnDiskResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVolumesOnDiskResponse.Unmarshal(m, b)
}
func (m *ListVolumesOnDiskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVolumesOnDiskResponse.Marshal(b, m, deterministic)
}
func (m *ListVolumesOnDiskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVolumesOnDiskResponse.Merge(m, src)
}
func (m *ListVolumesOnDiskResponse) XXX_Size() int {
	return xxx_messageInfo_ListVolumesOnDiskResponse.Size(m)
}
func (m *ListVolumesOnDiskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVolumesOnDiskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListVolumesOnDiskResponse proto.InternalMessageInfo

func (m *ListVolumesOnDiskResponse) GetVolumeIds() []string {
	if m != nil {
		return m.VolumeIds
	}
	return nil
}

type MountVolumeRequest struct {
	// Volume device ID of the volume to mount
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// Path in the host's file system where the volume needs to be mounted
	Path                 string   `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MountVolumeRequest) Reset()         { *m = MountVolumeRequest{} }
func (m *MountVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*MountVolumeRequest) ProtoMessage()    {}
func (*MountVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{2}
}

func (m *MountVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MountVolumeRequest.Unmarshal(m, b)
}
func (m *MountVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MountVolumeRequest.Marshal(b, m, deterministic)
}
func (m *MountVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MountVolumeRequest.Merge(m, src)
}
func (m *MountVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_MountVolumeRequest.Size(m)
}
func (m *MountVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MountVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MountVolumeRequest proto.InternalMessageInfo

func (m *MountVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *MountVolumeRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

type MountVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MountVolumeResponse) Reset()         { *m = MountVolumeResponse{} }
func (m *MountVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*MountVolumeResponse) ProtoMessage()    {}
func (*MountVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{3}
}

func (m *MountVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MountVolumeResponse.Unmarshal(m, b)
}
func (m *MountVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MountVolumeResponse.Marshal(b, m, deterministic)
}
func (m *MountVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MountVolumeResponse.Merge(m, src)
}
func (m *MountVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_MountVolumeResponse.Size(m)
}
func (m *MountVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MountVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MountVolumeResponse proto.InternalMessageInfo

type DismountVolumeRequest struct {
	// Volume device ID of the volume to dismount
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// Path where the volume has been mounted.
	Path                 string   `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismountVolumeRequest) Reset()         { *m = DismountVolumeRequest{} }
func (m *DismountVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*DismountVolumeRequest) ProtoMessage()    {}
func (*DismountVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{4}
}

func (m *DismountVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismountVolumeRequest.Unmarshal(m, b)
}
func (m *DismountVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismountVolumeRequest.Marshal(b, m, deterministic)
}
func (m *DismountVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismountVolumeRequest.Merge(m, src)
}
func (m *DismountVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_DismountVolumeRequest.Size(m)
}
func (m *DismountVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DismountVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DismountVolumeRequest proto.InternalMessageInfo

func (m *DismountVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *DismountVolumeRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

type DismountVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismountVolumeResponse) Reset()         { *m = DismountVolumeResponse{} }
func (m *DismountVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*DismountVolumeResponse) ProtoMessage()    {}
func (*DismountVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{5}
}

func (m *DismountVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismountVolumeResponse.Unmarshal(m, b)
}
func (m *DismountVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismountVolumeResponse.Marshal(b, m, deterministic)
}
func (m *DismountVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismountVolumeResponse.Merge(m, src)
}
func (m *DismountVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_DismountVolumeResponse.Size(m)
}
func (m *DismountVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DismountVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DismountVolumeResponse proto.InternalMessageInfo

type IsVolumeFormattedRequest struct {
	// Volume device ID of the volume to check
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsVolumeFormattedRequest) Reset()         { *m = IsVolumeFormattedRequest{} }
func (m *IsVolumeFormattedRequest) String() string { return proto.CompactTextString(m) }
func (*IsVolumeFormattedRequest) ProtoMessage()    {}
func (*IsVolumeFormattedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{6}
}

func (m *IsVolumeFormattedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IsVolumeFormattedRequest.Unmarshal(m, b)
}
func (m *IsVolumeFormattedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IsVolumeFormattedRequest.Marshal(b, m, deterministic)
}
func (m *IsVolumeFormattedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsVolumeFormattedRequest.Merge(m, src)
}
func (m *IsVolumeFormattedRequest) XXX_Size() int {
	return xxx_messageInfo_IsVolumeFormattedRequest.Size(m)
}
func (m *IsVolumeFormattedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IsVolumeFormattedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IsVolumeFormattedRequest proto.InternalMessageInfo

func (m *IsVolumeFormattedRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

type IsVolumeFormattedResponse struct {
	// Is the volume formatted with NTFS
	Formatted            bool     `protobuf:"varint,1,opt,name=formatted,proto3" json:"formatted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsVolumeFormattedResponse) Reset()         { *m = IsVolumeFormattedResponse{} }
func (m *IsVolumeFormattedResponse) String() string { return proto.CompactTextString(m) }
func (*IsVolumeFormattedResponse) ProtoMessage()    {}
func (*IsVolumeFormattedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{7}
}

func (m *IsVolumeFormattedResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IsVolumeFormattedResponse.Unmarshal(m, b)
}
func (m *IsVolumeFormattedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IsVolumeFormattedResponse.Marshal(b, m, deterministic)
}
func (m *IsVolumeFormattedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsVolumeFormattedResponse.Merge(m, src)
}
func (m *IsVolumeFormattedResponse) XXX_Size() int {
	return xxx_messageInfo_IsVolumeFormattedResponse.Size(m)
}
func (m *IsVolumeFormattedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_IsVolumeFormattedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_IsVolumeFormattedResponse proto.InternalMessageInfo

func (m *IsVolumeFormattedResponse) GetFormatted() bool {
	if m != nil {
		return m.Formatted
	}
	return false
}

type FormatVolumeRequest struct {
	// Volume device ID of the volume to format
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FormatVolumeRequest) Reset()         { *m = FormatVolumeRequest{} }
func (m *FormatVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*FormatVolumeRequest) ProtoMessage()    {}
func (*FormatVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{8}
}

func (m *FormatVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FormatVolumeRequest.Unmarshal(m, b)
}
func (m *FormatVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FormatVolumeRequest.Marshal(b, m, deterministic)
}
func (m *FormatVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FormatVolumeRequest.Merge(m, src)
}
func (m *FormatVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_FormatVolumeRequest.Size(m)
}
func (m *FormatVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FormatVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FormatVolumeRequest proto.InternalMessageInfo

func (m *FormatVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

type FormatVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FormatVolumeResponse) Reset()         { *m = FormatVolumeResponse{} }
func (m *FormatVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*FormatVolumeResponse) ProtoMessage()    {}
func (*FormatVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{9}
}

func (m *FormatVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FormatVolumeResponse.Unmarshal(m, b)
}
func (m *FormatVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FormatVolumeResponse.Marshal(b, m, deterministic)
}
func (m *FormatVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FormatVolumeResponse.Merge(m, src)
}
func (m *FormatVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_FormatVolumeResponse.Size(m)
}
func (m *FormatVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FormatVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FormatVolumeResponse proto.InternalMessageInfo

type ResizeVolumeRequest struct {
	// Volume device ID of the volume to dismount
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// New size of the volume
	Size                 int64    `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResizeVolumeRequest) Reset()         { *m = ResizeVolumeRequest{} }
func (m *ResizeVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*ResizeVolumeRequest) ProtoMessage()    {}
func (*ResizeVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{10}
}

func (m *ResizeVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResizeVolumeRequest.Unmarshal(m, b)
}
func (m *ResizeVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResizeVolumeRequest.Marshal(b, m, deterministic)
}
func (m *ResizeVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResizeVolumeRequest.Merge(m, src)
}
func (m *ResizeVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_ResizeVolumeRequest.Size(m)
}
func (m *ResizeVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResizeVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResizeVolumeRequest proto.InternalMessageInfo

func (m *ResizeVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ResizeVolumeRequest) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type ResizeVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResizeVolumeResponse) Reset()         { *m = ResizeVolumeResponse{} }
func (m *ResizeVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*ResizeVolumeResponse) ProtoMessage()    {}
func (*ResizeVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f4ca3596f93fa877, []int{11}
}

func (m *ResizeVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResizeVolumeResponse.Unmarshal(m, b)
}
func (m *ResizeVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResizeVolumeResponse.Marshal(b, m, deterministic)
}
func (m *ResizeVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResizeVolumeResponse.Merge(m, src)
}
func (m *ResizeVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_ResizeVolumeResponse.Size(m)
}
func (m *ResizeVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResizeVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResizeVolumeResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ListVolumesOnDiskRequest)(nil), "v1alpha1.ListVolumesOnDiskRequest")
	proto.RegisterType((*ListVolumesOnDiskResponse)(nil), "v1alpha1.ListVolumesOnDiskResponse")
	proto.RegisterType((*MountVolumeRequest)(nil), "v1alpha1.MountVolumeRequest")
	proto.RegisterType((*MountVolumeResponse)(nil), "v1alpha1.MountVolumeResponse")
	proto.RegisterType((*DismountVolumeRequest)(nil), "v1alpha1.DismountVolumeRequest")
	proto.RegisterType((*DismountVolumeResponse)(nil), "v1alpha1.DismountVolumeResponse")
	proto.RegisterType((*IsVolumeFormattedRequest)(nil), "v1alpha1.IsVolumeFormattedRequest")
	proto.RegisterType((*IsVolumeFormattedResponse)(nil), "v1alpha1.IsVolumeFormattedResponse")
	proto.RegisterType((*FormatVolumeRequest)(nil), "v1alpha1.FormatVolumeRequest")
	proto.RegisterType((*FormatVolumeResponse)(nil), "v1alpha1.FormatVolumeResponse")
	proto.RegisterType((*ResizeVolumeRequest)(nil), "v1alpha1.ResizeVolumeRequest")
	proto.RegisterType((*ResizeVolumeResponse)(nil), "v1alpha1.ResizeVolumeResponse")
}

func init() {
	proto.RegisterFile("github.com/kubernetes-csi/csi-proxy/client/api/volume/v1alpha1/api.proto", fileDescriptor_f4ca3596f93fa877)
}

var fileDescriptor_f4ca3596f93fa877 = []byte{
	// 429 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0x5f, 0xef, 0xd2, 0x30,
	0x14, 0x05, 0x21, 0xc8, 0xae, 0xc6, 0x84, 0x22, 0x38, 0x26, 0x28, 0xa9, 0x2f, 0xbc, 0xb0, 0x05,
	0x78, 0x30, 0xfa, 0x8c, 0x04, 0x12, 0x0c, 0xc9, 0x12, 0x7d, 0x84, 0x8c, 0xad, 0x4a, 0x03, 0x5b,
	0xe7, 0xda, 0x11, 0xf5, 0x4b, 0xf8, 0x95, 0xcd, 0xfe, 0x41, 0x27, 0x9b, 0xe1, 0x97, 0xfc, 0xde,
	0xba, 0xd3, 0x7b, 0xce, 0xd9, 0xbd, 0xf7, 0xa4, 0xb0, 0xfc, 0x4e, 0xc5, 0x21, 0xdc, 0xeb, 0x36,
	0x73, 0x8d, 0x63, 0xb8, 0x27, 0x81, 0x47, 0x04, 0xe1, 0x63, 0x9b, 0x53, 0xc3, 0xe6, 0x74, 0xec,
	0x07, 0xec, 0xe7, 0x2f, 0xc3, 0x3e, 0x51, 0xe2, 0x09, 0xc3, 0xf2, 0xa9, 0x71, 0x66, 0xa7, 0xd0,
	0x25, 0xc6, 0x79, 0x62, 0x9d, 0xfc, 0x83, 0x35, 0x89, 0x30, 0xdd, 0x0f, 0x98, 0x60, 0xa8, 0x99,
	0x61, 0x78, 0x06, 0xea, 0x9a, 0x72, 0xf1, 0x35, 0x2e, 0xe5, 0x1b, 0x6f, 0x4e, 0xf9, 0xd1, 0x24,
	0x3f, 0x42, 0xc2, 0x05, 0x7a, 0x05, 0x4f, 0x1d, 0xca, 0x8f, 0x3b, 0xea, 0xa8, 0xd5, 0x61, 0x75,
	0xa4, 0x98, 0x8d, 0xe8, 0x73, 0xe5, 0xe0, 0x8f, 0xd0, 0x2b, 0x20, 0x71, 0x9f, 0x79, 0x9c, 0xa0,
	0x01, 0x40, 0x62, 0xbc, 0xa3, 0x0e, 0x57, 0xab, 0xc3, 0xda, 0x48, 0x31, 0x95, 0x04, 0x59, 0x39,
	0x1c, 0x7f, 0x02, 0xf4, 0x99, 0x85, 0x5e, 0x4a, 0xce, 0xac, 0x5e, 0x83, 0x72, 0x21, 0xa5, 0x66,
	0xcd, 0x8c, 0x83, 0x10, 0xd4, 0x7d, 0x4b, 0x1c, 0xd4, 0x27, 0x31, 0x1e, 0x9f, 0x71, 0x07, 0xda,
	0x39, 0x99, 0xc4, 0x1c, 0x2f, 0xa1, 0x33, 0xa7, 0xdc, 0x7d, 0x04, 0x03, 0x15, 0xba, 0xff, 0x2a,
	0xa5, 0x1e, 0xef, 0x41, 0x5d, 0xf1, 0x04, 0x5b, 0xb0, 0xc0, 0xb5, 0x84, 0x20, 0xce, 0x3d, 0x36,
	0xf8, 0x03, 0xf4, 0x0a, 0x88, 0xe9, 0xd8, 0xfa, 0xa0, 0x7c, 0xcb, 0xc0, 0x98, 0xd9, 0x34, 0xaf,
	0x00, 0x9e, 0x42, 0x3b, 0xa1, 0xdc, 0xdf, 0x15, 0xee, 0xc2, 0xcb, 0x3c, 0x27, 0xfd, 0xff, 0x05,
	0xb4, 0x4d, 0xc2, 0xe9, 0x6f, 0xf2, 0xb0, 0x09, 0x45, 0x8c, 0x78, 0x42, 0x35, 0x33, 0x3e, 0x47,
	0xfa, 0x79, 0x9d, 0x44, 0x7f, 0xfa, 0xa7, 0x0e, 0x8d, 0x04, 0x42, 0x5b, 0x68, 0xdd, 0x04, 0x05,
	0x61, 0x3d, 0x4b, 0x9f, 0x5e, 0x16, 0x3d, 0xed, 0xdd, 0x7f, 0x6b, 0xd2, 0x46, 0x2a, 0x68, 0x0d,
	0xcf, 0xa4, 0x14, 0xa0, 0xfe, 0x95, 0x75, 0x9b, 0x31, 0x6d, 0x50, 0x72, 0x7b, 0x51, 0xfb, 0x02,
	0x2f, 0xf2, 0x2b, 0x47, 0x6f, 0xaf, 0x94, 0xc2, 0x58, 0x69, 0xc3, 0xf2, 0x82, 0x8b, 0xec, 0x16,
	0x5a, 0x37, 0x6b, 0x97, 0x87, 0x50, 0x16, 0x26, 0x79, 0x08, 0xa5, 0xb9, 0xc1, 0x15, 0xb4, 0x81,
	0xe7, 0xf2, 0x9e, 0x91, 0xd4, 0x67, 0x41, 0x66, 0xb4, 0x37, 0x65, 0xd7, 0xb2, 0xa0, 0xbc, 0x58,
	0x59, 0xb0, 0x20, 0x38, 0xb2, 0x60, 0x51, 0x1e, 0x70, 0x65, 0xdf, 0x88, 0x5f, 0x9d, 0xd9, 0xdf,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xbb, 0x8e, 0xe9, 0xb0, 0xc1, 0x04, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VolumeClient is the client API for Volume service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VolumeClient interface {
	// ListVolumesOnDisk returns the volume IDs (in \\.\Volume{GUID} format) for
	// all volumes on a Disk device
	ListVolumesOnDisk(ctx context.Context, in *ListVolumesOnDiskRequest, opts ...grpc.CallOption) (*ListVolumesOnDiskResponse, error)
	// MountVolume mounts the volume at the requested global staging path
	MountVolume(ctx context.Context, in *MountVolumeRequest, opts ...grpc.CallOption) (*MountVolumeResponse, error)
	// DismountVolume gracefully dismounts a volume
	DismountVolume(ctx context.Context, in *DismountVolumeRequest, opts ...grpc.CallOption) (*DismountVolumeResponse, error)
	// IsVolumeFormatted checks if a volume is formatted with NTFS
	IsVolumeFormatted(ctx context.Context, in *IsVolumeFormattedRequest, opts ...grpc.CallOption) (*IsVolumeFormattedResponse, error)
	// FormatVolume formats a volume with the provided file system
	FormatVolume(ctx context.Context, in *FormatVolumeRequest, opts ...grpc.CallOption) (*FormatVolumeResponse, error)
	// ResizeVolume performs resizing of the partition and file system for a block based volume
	ResizeVolume(ctx context.Context, in *ResizeVolumeRequest, opts ...grpc.CallOption) (*ResizeVolumeResponse, error)
}

type volumeClient struct {
	cc grpc.ClientConnInterface
}

func NewVolumeClient(cc grpc.ClientConnInterface) VolumeClient {
	return &volumeClient{cc}
}

func (c *volumeClient) ListVolumesOnDisk(ctx context.Context, in *ListVolumesOnDiskRequest, opts ...grpc.CallOption) (*ListVolumesOnDiskResponse, error) {
	out := new(ListVolumesOnDiskResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Volume/ListVolumesOnDisk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volumeClient) MountVolume(ctx context.Context, in *MountVolumeRequest, opts ...grpc.CallOption) (*MountVolumeResponse, error) {
	out := new(MountVolumeResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Volume/MountVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volumeClient) DismountVolume(ctx context.Context, in *DismountVolumeRequest, opts ...grpc.CallOption) (*DismountVolumeResponse, error) {
	out := new(DismountVolumeResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Volume/DismountVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volumeClient) IsVolumeFormatted(ctx context.Context, in *IsVolumeFormattedRequest, opts ...grpc.CallOption) (*IsVolumeFormattedResponse, error) {
	out := new(IsVolumeFormattedResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Volume/IsVolumeFormatted", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volumeClient) FormatVolume(ctx context.Context, in *FormatVolumeRequest, opts ...grpc.CallOption) (*FormatVolumeResponse, error) {
	out := new(FormatVolumeResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Volume/FormatVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volumeClient) ResizeVolume(ctx context.Context, in *ResizeVolumeRequest, opts ...grpc.CallOption) (*ResizeVolumeResponse, error) {
	out := new(ResizeVolumeResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Volume/ResizeVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VolumeServer is the server API for Volume service.
type VolumeServer interface {
	// ListVolumesOnDisk returns the volume IDs (in \\.\Volume{GUID} format) for
	// all volumes on a Disk device
	ListVolumesOnDisk(context.Context, *ListVolumesOnDiskRequest) (*ListVolumesOnDiskResponse, error)
	// MountVolume mounts the volume at the requested global staging path
	MountVolume(context.Context, *MountVolumeRequest) (*MountVolumeResponse, error)
	// DismountVolume gracefully dismounts a volume
	DismountVolume(context.Context, *DismountVolumeRequest) (*DismountVolumeResponse, error)
	// IsVolumeFormatted checks if a volume is formatted with NTFS
	IsVolumeFormatted(context.Context, *IsVolumeFormattedRequest) (*IsVolumeFormattedResponse, error)
	// FormatVolume formats a volume with the provided file system
	FormatVolume(context.Context, *FormatVolumeRequest) (*FormatVolumeResponse, error)
	// ResizeVolume performs resizing of the partition and file system for a block based volume
	ResizeVolume(context.Context, *ResizeVolumeRequest) (*ResizeVolumeResponse, error)
}

// UnimplementedVolumeServer can be embedded to have forward compatible implementations.
type UnimplementedVolumeServer struct {
}

func (*UnimplementedVolumeServer) ListVolumesOnDisk(ctx context.Context, req *ListVolumesOnDiskRequest) (*ListVolumesOnDiskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumesOnDisk not implemented")
}
func (*UnimplementedVolumeServer) MountVolume(ctx context.Context, req *MountVolumeRequest) (*MountVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MountVolume not implemented")
}
func (*UnimplementedVolumeServer) DismountVolume(ctx context.Context, req *DismountVolumeRequest) (*DismountVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DismountVolume not implemented")
}
func (*UnimplementedVolumeServer) IsVolumeFormatted(ctx context.Context, req *IsVolumeFormattedRequest) (*IsVolumeFormattedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsVolumeFormatted not implemented")
}
func (*UnimplementedVolumeServer) FormatVolume(ctx context.Context, req *FormatVolumeRequest) (*FormatVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FormatVolume not implemented")
}
func (*UnimplementedVolumeServer) ResizeVolume(ctx context.Context, req *ResizeVolumeRequest) (*ResizeVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResizeVolume not implemented")
}

func RegisterVolumeServer(s *grpc.Server, srv VolumeServer) {
	s.RegisterService(&_Volume_serviceDesc, srv)
}

func _Volume_ListVolumesOnDisk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumesOnDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolumeServer).ListVolumesOnDisk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Volume/ListVolumesOnDisk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolumeServer).ListVolumesOnDisk(ctx, req.(*ListVolumesOnDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Volume_MountVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MountVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolumeServer).MountVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Volume/MountVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolumeServer).MountVolume(ctx, req.(*MountVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Volume_DismountVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DismountVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolumeServer).DismountVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Volume/DismountVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolumeServer).DismountVolume(ctx, req.(*DismountVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Volume_IsVolumeFormatted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsVolumeFormattedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolumeServer).IsVolumeFormatted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Volume/IsVolumeFormatted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolumeServer).IsVolumeFormatted(ctx, req.(*IsVolumeFormattedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Volume_FormatVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FormatVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolumeServer).FormatVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Volume/FormatVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolumeServer).FormatVolume(ctx, req.(*FormatVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Volume_ResizeVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResizeVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolumeServer).ResizeVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Volume/ResizeVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolumeServer).ResizeVolume(ctx, req.(*ResizeVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Volume_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1alpha1.Volume",
	HandlerType: (*VolumeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListVolumesOnDisk",
			Handler:    _Volume_ListVolumesOnDisk_Handler,
		},
		{
			MethodName: "MountVolume",
			Handler:    _Volume_MountVolume_Handler,
		},
		{
			MethodName: "DismountVolume",
			Handler:    _Volume_DismountVolume_Handler,
		},
		{
			MethodName: "IsVolumeFormatted",
			Handler:    _Volume_IsVolumeFormatted_Handler,
		},
		{
			MethodName: "FormatVolume",
			Handler:    _Volume_FormatVolume_Handler,
		},
		{
			MethodName: "ResizeVolume",
			Handler:    _Volume_ResizeVolume_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/kubernetes-csi/csi-proxy/client/api/volume/v1alpha1/api.proto",
}
