package main

import (
	"flag"
	"fmt"
	"math/rand"
	"os"
	"time"

	"github.com/spf13/cobra"
	"github.com/spf13/pflag"

	k8sflag "k8s.io/component-base/cli/flag"
	"k8s.io/component-base/logs"

	"github.com/openshift/library-go/pkg/controller/controllercmd"

	"github.com/openshift/aws-efs-csi-driver-operator/pkg/efscreate"
	"github.com/openshift/aws-efs-csi-driver-operator/pkg/version"
)

func main() {
	rand.Seed(time.Now().UTC().UnixNano())

	pflag.CommandLine.SetNormalizeFunc(k8sflag.WordSepNormalizeFunc)
	pflag.CommandLine.AddGoFlagSet(flag.CommandLine)

	logs.InitLogs()
	defer logs.FlushLogs()

	command := NewOperatorCommand()
	if err := command.Execute(); err != nil {
		fmt.Fprintf(os.Stderr, "%v\n", err)
		os.Exit(1)
	}
}

func NewOperatorCommand() *cobra.Command {
	cmd := &cobra.Command{
		Use:   "create-efs-volume",
		Short: "OpenShift AWS EFS Create EFS Volume",
		Run: func(cmd *cobra.Command, args []string) {
			cmd.Help()
			os.Exit(1)
		},
	}

	ctrlCmdConfig := controllercmd.NewControllerCommandConfig(
		"create-efs-volume",
		version.Get(),
		efscreate.RunOperator,
	)
	// we don't need leader election and metrics for CLI commands
	ctrlCmdConfig.DisableLeaderElection = true
	ctrlCmdConfig.DisableServing = true

	ctrlCmd := ctrlCmdConfig.NewCommand()
	ctrlCmd.Use = "start"
	ctrlCmd.Short = "Create EFS volume"

	cmd.AddCommand(ctrlCmd)

	return cmd
}
