---
title: "v0.7.5"
linkTitle: "v0.7.5"
date: 2021-06-21
description: >
  Cloud Provider Azure v0.7.5
---

# Major changes since v0.7.4

## Changes by Kind

### Feature

- Chore: upgrade TLS1.0 to TLS1.2 in account creation ([#675](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/675), [@andyzhangx](https://github.com/andyzhangx))
- Feat: Enable creation of storage accounts that support large file shares ([#606](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/606), [@nearora-msft](https://github.com/nearora-msft))
- Feat: add support for additional public IPs via service annotation "service.beta.kubernetes.io/azure-additional-public-ips" ([#691](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/691), [@feiskyer](https://github.com/feiskyer))
- Feat: enable creation of private endpoint for storage account ([#652](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/652), [@nearora-msft](https://github.com/nearora-msft))
- Feat: support reloading cloud controller manager from secret dynamically ([#613](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/613), [@nilo19](https://github.com/nilo19))

### Documentation

- Chore: update docs for service tags NSG ([#647](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/647), [@feiskyer](https://github.com/feiskyer))
- Docs: add 'securityGroupResourceGroup' cloud-config value ([#668](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/668), [@aslafy-z](https://github.com/aslafy-z))

### Failing Test

- Fix: serviceOwnsFrontendIP shouldn't report error when the public IP doesn't match ([#649](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/649), [@feiskyer](https://github.com/feiskyer))

### Bug or Regression

- Do not set cached Sku when updating VMSS and VMSS instances ([#630](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/630), [@feiskyer](https://github.com/feiskyer))
- Fix: avoid nil-pointer panic when checking the frontend IP configuration ([#615](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/615), [@nilo19](https://github.com/nilo19))
- Fix: cleanup outdated routes ([#661](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/661), [@nilo19](https://github.com/nilo19))
- Fix: detach disk panic on Azure Stack ([#688](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/688), [@andyzhangx](https://github.com/andyzhangx))
- Fix: make tags case-insensitive for both keys and values ([#669](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/669), [@nilo19](https://github.com/nilo19))
- Fix: not tagging static public IP ([#616](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/616), [@nilo19](https://github.com/nilo19))
- Fix: remove GetDisk operation in AttachDisk ([#678](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/678), [@andyzhangx](https://github.com/andyzhangx))
- Fix: return empty VMAS name if using standalone VM ([#679](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/679), [@nilo19](https://github.com/nilo19))

### Other (Cleanup or Flake)

- Chore: add e2e test for byo public IP ([#627](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/627), [@nilo19](https://github.com/nilo19))
- Chore: add more buckets for operation metrics ([#656](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/656), [@andyzhangx](https://github.com/andyzhangx))
- Chore: completely decouple k/k ([#601](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/601), [@nilo19](https://github.com/nilo19))
- Chore: only logs rate limiting configurations when rate limit is enabled ([#608](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/608), [@feiskyer](https://github.com/feiskyer))
- Chore: only put pip if it is necessary ([#686](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/686), [@nilo19](https://github.com/nilo19))
- Chore: only reconciling routes in cloud controller manager ([#671](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/671), [@nilo19](https://github.com/nilo19))
- Chore: set default config secret name and namespace ([#662](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/662), [@nilo19](https://github.com/nilo19))
- Fix: wait for the success of the initial run of syncRegionZonesMap ([#646](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/646), [@nilo19](https://github.com/nilo19))
- Update Azure Go SDK to v55.0.0 ([#643](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/643), [@feiskyer](https://github.com/feiskyer))
- Update cloud-provider vendor to v1.21 ([#603](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/603), [@feiskyer](https://github.com/feiskyer))
- Upgrade to 2020-02-01/storage ([#628](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/628), [@andyzhangx](https://github.com/andyzhangx))
- `GetTestCloud` properly initializes the disk controller fields enabling them to be used in unit tests and mocked. ([#689](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/689), [@edreed](https://github.com/edreed))

### Uncategorized

- Add CreateOrUpdateBackendPools() interface for LoadBalancer client ([#620](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/620), [@feiskyer](https://github.com/feiskyer))
- Feat: add NFSv3 account creation support ([#633](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/633), [@andyzhangx](https://github.com/andyzhangx))
- Fix: leave the probe path empty for TCP probes ([#680](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/680), [@nilo19](https://github.com/nilo19))
- Fix: no sleep when GetDisk is throttled ([#629](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/629), [@andyzhangx](https://github.com/andyzhangx))

## Dependencies

### Added
_Nothing has changed._

### Changed
_Nothing has changed._

### Removed
_Nothing has changed._
