package azfile

// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/base64"
	"encoding/xml"
	"github.com/Azure/azure-pipeline-go/pipeline"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"strconv"
)

// fileClient is the client for the File methods of the Azfile service.
type fileClient struct {
	managementClient
}

// newFileClient creates an instance of the fileClient client.
func newFileClient(url url.URL, p pipeline.Pipeline) fileClient {
	return fileClient{newManagementClient(url, p)}
}

// AbortCopy aborts a pending Copy File operation, and leaves a destination file with zero length and full metadata.
//
// copyID is the copy identifier provided in the x-ms-copy-id header of the original Copy File operation. timeout is
// the timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a>
func (client fileClient) AbortCopy(ctx context.Context, copyID string, timeout *int32) (*FileAbortCopyResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.abortCopyPreparer(copyID, timeout)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.abortCopyResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileAbortCopyResponse), err
}

// abortCopyPreparer prepares the AbortCopy request.
func (client fileClient) abortCopyPreparer(copyID string, timeout *int32) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("PUT", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	params.Set("copyid", copyID)
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	params.Set("comp", "copy")
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-copy-action", "abort")
	req.Header.Set("x-ms-version", ServiceVersion)
	return req, nil
}

// abortCopyResponder handles the response to the AbortCopy request.
func (client fileClient) abortCopyResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusNoContent)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileAbortCopyResponse{rawResponse: resp.Response()}, err
}

// Create creates a new file or replaces a file. Note it only initializes the file with no content.
//
// fileContentLength is specifies the maximum size for the file, up to 1 TB. fileAttributes is if specified, the
// provided file attributes shall be set. Default value: ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can
// also be specified as default. fileCreationTime is creation time for the file/directory. Default value: Now.
// fileLastWriteTime is last write time for the file/directory. Default value: Now. timeout is the timeout parameter is
// expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> fileContentType is sets the MIME content type of the file. The default
// type is 'application/octet-stream'. fileContentEncoding is specifies which content encodings have been applied to
// the file. fileContentLanguage is specifies the natural languages used by this resource. fileCacheControl is sets the
// file's cache control. The File service stores this value but does not use or modify it. fileContentMD5 is sets the
// file's MD5 hash. fileContentDisposition is sets the file's Content-Disposition header. metadata is a name-value pair
// to associate with a file storage object. filePermission is if specified the permission (security descriptor) shall
// be set for the directory/file. This header can be used if Permission size is <= 8KB, else x-ms-file-permission-key
// header shall be used. Default value: Inherit. If SDDL is specified as input, it must have owner, group and dacl.
// Note: Only one of the x-ms-file-permission or x-ms-file-permission-key should be specified. filePermissionKey is key
// of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or
// x-ms-file-permission-key should be specified.
func (client fileClient) Create(ctx context.Context, fileContentLength int64, fileAttributes string, fileCreationTime string, fileLastWriteTime string, timeout *int32, fileContentType *string, fileContentEncoding *string, fileContentLanguage *string, fileCacheControl *string, fileContentMD5 []byte, fileContentDisposition *string, metadata map[string]string, filePermission *string, filePermissionKey *string) (*FileCreateResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.createPreparer(fileContentLength, fileAttributes, fileCreationTime, fileLastWriteTime, timeout, fileContentType, fileContentEncoding, fileContentLanguage, fileCacheControl, fileContentMD5, fileContentDisposition, metadata, filePermission, filePermissionKey)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.createResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileCreateResponse), err
}

// createPreparer prepares the Create request.
func (client fileClient) createPreparer(fileContentLength int64, fileAttributes string, fileCreationTime string, fileLastWriteTime string, timeout *int32, fileContentType *string, fileContentEncoding *string, fileContentLanguage *string, fileCacheControl *string, fileContentMD5 []byte, fileContentDisposition *string, metadata map[string]string, filePermission *string, filePermissionKey *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("PUT", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	req.Header.Set("x-ms-content-length", strconv.FormatInt(fileContentLength, 10))
	req.Header.Set("x-ms-type", "file")
	if fileContentType != nil {
		req.Header.Set("x-ms-content-type", *fileContentType)
	}
	if fileContentEncoding != nil {
		req.Header.Set("x-ms-content-encoding", *fileContentEncoding)
	}
	if fileContentLanguage != nil {
		req.Header.Set("x-ms-content-language", *fileContentLanguage)
	}
	if fileCacheControl != nil {
		req.Header.Set("x-ms-cache-control", *fileCacheControl)
	}
	if fileContentMD5 != nil {
		req.Header.Set("x-ms-content-md5", base64.StdEncoding.EncodeToString(fileContentMD5))
	}
	if fileContentDisposition != nil {
		req.Header.Set("x-ms-content-disposition", *fileContentDisposition)
	}
	if metadata != nil {
		for k, v := range metadata {
			req.Header.Set("x-ms-meta-"+k, v)
		}
	}
	if filePermission != nil {
		req.Header.Set("x-ms-file-permission", *filePermission)
	}
	if filePermissionKey != nil {
		req.Header.Set("x-ms-file-permission-key", *filePermissionKey)
	}
	req.Header.Set("x-ms-file-attributes", fileAttributes)
	req.Header.Set("x-ms-file-creation-time", fileCreationTime)
	req.Header.Set("x-ms-file-last-write-time", fileLastWriteTime)
	return req, nil
}

// createResponder handles the response to the Create request.
func (client fileClient) createResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusCreated)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileCreateResponse{rawResponse: resp.Response()}, err
}

// Delete removes the file from the storage account.
//
// timeout is the timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a>
func (client fileClient) Delete(ctx context.Context, timeout *int32) (*FileDeleteResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.deletePreparer(timeout)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.deleteResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileDeleteResponse), err
}

// deletePreparer prepares the Delete request.
func (client fileClient) deletePreparer(timeout *int32) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("DELETE", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	return req, nil
}

// deleteResponder handles the response to the Delete request.
func (client fileClient) deleteResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusAccepted)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileDeleteResponse{rawResponse: resp.Response()}, err
}

// Download reads or downloads a file from the system, including its metadata and properties.
//
// timeout is the timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> rangeParameter is return file data only from the specified byte range.
// rangeGetContentMD5 is when this header is set to true and specified together with the Range header, the service
// returns the MD5 hash for the range, as long as the range is less than or equal to 4 MB in size.
func (client fileClient) Download(ctx context.Context, timeout *int32, rangeParameter *string, rangeGetContentMD5 *bool) (*DownloadResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.downloadPreparer(timeout, rangeParameter, rangeGetContentMD5)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.downloadResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*DownloadResponse), err
}

// downloadPreparer prepares the Download request.
func (client fileClient) downloadPreparer(timeout *int32, rangeParameter *string, rangeGetContentMD5 *bool) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("GET", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if rangeParameter != nil {
		req.Header.Set("x-ms-range", *rangeParameter)
	}
	if rangeGetContentMD5 != nil {
		req.Header.Set("x-ms-range-get-content-md5", strconv.FormatBool(*rangeGetContentMD5))
	}
	return req, nil
}

// downloadResponder handles the response to the Download request.
func (client fileClient) downloadResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusPartialContent)
	if resp == nil {
		return nil, err
	}
	return &DownloadResponse{rawResponse: resp.Response()}, err
}

// ForceCloseHandles closes all handles open for given file
//
// handleID is specifies handle ID opened on the file or directory to be closed. Asterix (‘*’) is a wildcard that
// specifies all handles. timeout is the timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> marker is a string value that identifies the portion of the list to be
// returned with the next list operation. The operation returns a marker value within the response body if the list
// returned was not complete. The marker value may then be used in a subsequent call to request the next set of list
// items. The marker value is opaque to the client. sharesnapshot is the snapshot parameter is an opaque DateTime value
// that, when present, specifies the share snapshot to query.
func (client fileClient) ForceCloseHandles(ctx context.Context, handleID string, timeout *int32, marker *string, sharesnapshot *string) (*FileForceCloseHandlesResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.forceCloseHandlesPreparer(handleID, timeout, marker, sharesnapshot)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.forceCloseHandlesResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileForceCloseHandlesResponse), err
}

// forceCloseHandlesPreparer prepares the ForceCloseHandles request.
func (client fileClient) forceCloseHandlesPreparer(handleID string, timeout *int32, marker *string, sharesnapshot *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("PUT", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	if marker != nil && len(*marker) > 0 {
		params.Set("marker", *marker)
	}
	if sharesnapshot != nil && len(*sharesnapshot) > 0 {
		params.Set("sharesnapshot", *sharesnapshot)
	}
	params.Set("comp", "forceclosehandles")
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-handle-id", handleID)
	req.Header.Set("x-ms-version", ServiceVersion)
	return req, nil
}

// forceCloseHandlesResponder handles the response to the ForceCloseHandles request.
func (client fileClient) forceCloseHandlesResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileForceCloseHandlesResponse{rawResponse: resp.Response()}, err
}

// GetProperties returns all user-defined metadata, standard HTTP properties, and system properties for the file. It
// does not return the content of the file.
//
// sharesnapshot is the snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot
// to query. timeout is the timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a>
func (client fileClient) GetProperties(ctx context.Context, sharesnapshot *string, timeout *int32) (*FileGetPropertiesResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.getPropertiesPreparer(sharesnapshot, timeout)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.getPropertiesResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileGetPropertiesResponse), err
}

// getPropertiesPreparer prepares the GetProperties request.
func (client fileClient) getPropertiesPreparer(sharesnapshot *string, timeout *int32) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("HEAD", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if sharesnapshot != nil && len(*sharesnapshot) > 0 {
		params.Set("sharesnapshot", *sharesnapshot)
	}
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	return req, nil
}

// getPropertiesResponder handles the response to the GetProperties request.
func (client fileClient) getPropertiesResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileGetPropertiesResponse{rawResponse: resp.Response()}, err
}

// GetRangeList returns the list of valid ranges for a file.
//
// sharesnapshot is the snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot
// to query. timeout is the timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> rangeParameter is specifies the range of bytes over which to list ranges,
// inclusively.
func (client fileClient) GetRangeList(ctx context.Context, sharesnapshot *string, timeout *int32, rangeParameter *string) (*Ranges, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.getRangeListPreparer(sharesnapshot, timeout, rangeParameter)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.getRangeListResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*Ranges), err
}

// getRangeListPreparer prepares the GetRangeList request.
func (client fileClient) getRangeListPreparer(sharesnapshot *string, timeout *int32, rangeParameter *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("GET", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if sharesnapshot != nil && len(*sharesnapshot) > 0 {
		params.Set("sharesnapshot", *sharesnapshot)
	}
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	params.Set("comp", "rangelist")
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if rangeParameter != nil {
		req.Header.Set("x-ms-range", *rangeParameter)
	}
	return req, nil
}

// getRangeListResponder handles the response to the GetRangeList request.
func (client fileClient) getRangeListResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK)
	if resp == nil {
		return nil, err
	}
	result := &Ranges{rawResponse: resp.Response()}
	if err != nil {
		return result, err
	}
	defer resp.Response().Body.Close()
	b, err := ioutil.ReadAll(resp.Response().Body)
	if err != nil {
		return result, err
	}
	if len(b) > 0 {
		b = removeBOM(b)
		err = xml.Unmarshal(b, result)
		if err != nil {
			return result, NewResponseError(err, resp.Response(), "failed to unmarshal response body")
		}
	}
	return result, nil
}

// ListHandles lists handles for file
//
// marker is a string value that identifies the portion of the list to be returned with the next list operation. The
// operation returns a marker value within the response body if the list returned was not complete. The marker value
// may then be used in a subsequent call to request the next set of list items. The marker value is opaque to the
// client. maxresults is specifies the maximum number of entries to return. If the request does not specify maxresults,
// or specifies a value greater than 5,000, the server will return up to 5,000 items. timeout is the timeout parameter
// is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> sharesnapshot is the snapshot parameter is an opaque DateTime value that,
// when present, specifies the share snapshot to query.
func (client fileClient) ListHandles(ctx context.Context, marker *string, maxresults *int32, timeout *int32, sharesnapshot *string) (*ListHandlesResponse, error) {
	if err := validate([]validation{
		{targetValue: maxresults,
			constraints: []constraint{{target: "maxresults", name: null, rule: false,
				chain: []constraint{{target: "maxresults", name: inclusiveMinimum, rule: 1, chain: nil}}}}},
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.listHandlesPreparer(marker, maxresults, timeout, sharesnapshot)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.listHandlesResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*ListHandlesResponse), err
}

// listHandlesPreparer prepares the ListHandles request.
func (client fileClient) listHandlesPreparer(marker *string, maxresults *int32, timeout *int32, sharesnapshot *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("GET", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if marker != nil && len(*marker) > 0 {
		params.Set("marker", *marker)
	}
	if maxresults != nil {
		params.Set("maxresults", strconv.FormatInt(int64(*maxresults), 10))
	}
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	if sharesnapshot != nil && len(*sharesnapshot) > 0 {
		params.Set("sharesnapshot", *sharesnapshot)
	}
	params.Set("comp", "listhandles")
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	return req, nil
}

// listHandlesResponder handles the response to the ListHandles request.
func (client fileClient) listHandlesResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK)
	if resp == nil {
		return nil, err
	}
	result := &ListHandlesResponse{rawResponse: resp.Response()}
	if err != nil {
		return result, err
	}
	defer resp.Response().Body.Close()
	b, err := ioutil.ReadAll(resp.Response().Body)
	if err != nil {
		return result, err
	}
	if len(b) > 0 {
		b = removeBOM(b)
		err = xml.Unmarshal(b, result)
		if err != nil {
			return result, NewResponseError(err, resp.Response(), "failed to unmarshal response body")
		}
	}
	return result, nil
}

// SetHTTPHeaders sets HTTP headers on the file.
//
// fileAttributes is if specified, the provided file attributes shall be set. Default value: ‘Archive’ for file and
// ‘Directory’ for directory. ‘None’ can also be specified as default. fileCreationTime is creation time for the
// file/directory. Default value: Now. fileLastWriteTime is last write time for the file/directory. Default value: Now.
// timeout is the timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> fileContentLength is resizes a file to the specified size. If the
// specified byte value is less than the current size of the file, then all ranges above the specified byte value are
// cleared. fileContentType is sets the MIME content type of the file. The default type is 'application/octet-stream'.
// fileContentEncoding is specifies which content encodings have been applied to the file. fileContentLanguage is
// specifies the natural languages used by this resource. fileCacheControl is sets the file's cache control. The File
// service stores this value but does not use or modify it. fileContentMD5 is sets the file's MD5 hash.
// fileContentDisposition is sets the file's Content-Disposition header. filePermission is if specified the permission
// (security descriptor) shall be set for the directory/file. This header can be used if Permission size is <= 8KB,
// else x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as input, it must
// have owner, group and dacl. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key should be
// specified. filePermissionKey is key of the permission to be set for the directory/file. Note: Only one of the
// x-ms-file-permission or x-ms-file-permission-key should be specified.
func (client fileClient) SetHTTPHeaders(ctx context.Context, fileAttributes string, fileCreationTime string, fileLastWriteTime string, timeout *int32, fileContentLength *int64, fileContentType *string, fileContentEncoding *string, fileContentLanguage *string, fileCacheControl *string, fileContentMD5 []byte, fileContentDisposition *string, filePermission *string, filePermissionKey *string) (*FileSetHTTPHeadersResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.setHTTPHeadersPreparer(fileAttributes, fileCreationTime, fileLastWriteTime, timeout, fileContentLength, fileContentType, fileContentEncoding, fileContentLanguage, fileCacheControl, fileContentMD5, fileContentDisposition, filePermission, filePermissionKey)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.setHTTPHeadersResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileSetHTTPHeadersResponse), err
}

// setHTTPHeadersPreparer prepares the SetHTTPHeaders request.
func (client fileClient) setHTTPHeadersPreparer(fileAttributes string, fileCreationTime string, fileLastWriteTime string, timeout *int32, fileContentLength *int64, fileContentType *string, fileContentEncoding *string, fileContentLanguage *string, fileCacheControl *string, fileContentMD5 []byte, fileContentDisposition *string, filePermission *string, filePermissionKey *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("PUT", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	params.Set("comp", "properties")
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if fileContentLength != nil {
		req.Header.Set("x-ms-content-length", strconv.FormatInt(*fileContentLength, 10))
	}
	if fileContentType != nil {
		req.Header.Set("x-ms-content-type", *fileContentType)
	}
	if fileContentEncoding != nil {
		req.Header.Set("x-ms-content-encoding", *fileContentEncoding)
	}
	if fileContentLanguage != nil {
		req.Header.Set("x-ms-content-language", *fileContentLanguage)
	}
	if fileCacheControl != nil {
		req.Header.Set("x-ms-cache-control", *fileCacheControl)
	}
	if fileContentMD5 != nil {
		req.Header.Set("x-ms-content-md5", base64.StdEncoding.EncodeToString(fileContentMD5))
	}
	if fileContentDisposition != nil {
		req.Header.Set("x-ms-content-disposition", *fileContentDisposition)
	}
	if filePermission != nil {
		req.Header.Set("x-ms-file-permission", *filePermission)
	}
	if filePermissionKey != nil {
		req.Header.Set("x-ms-file-permission-key", *filePermissionKey)
	}
	req.Header.Set("x-ms-file-attributes", fileAttributes)
	req.Header.Set("x-ms-file-creation-time", fileCreationTime)
	req.Header.Set("x-ms-file-last-write-time", fileLastWriteTime)
	return req, nil
}

// setHTTPHeadersResponder handles the response to the SetHTTPHeaders request.
func (client fileClient) setHTTPHeadersResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileSetHTTPHeadersResponse{rawResponse: resp.Response()}, err
}

// SetMetadata updates user-defined metadata for the specified file.
//
// timeout is the timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> metadata is a name-value pair to associate with a file storage object.
func (client fileClient) SetMetadata(ctx context.Context, timeout *int32, metadata map[string]string) (*FileSetMetadataResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.setMetadataPreparer(timeout, metadata)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.setMetadataResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileSetMetadataResponse), err
}

// setMetadataPreparer prepares the SetMetadata request.
func (client fileClient) setMetadataPreparer(timeout *int32, metadata map[string]string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("PUT", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	params.Set("comp", "metadata")
	req.URL.RawQuery = params.Encode()
	if metadata != nil {
		for k, v := range metadata {
			req.Header.Set("x-ms-meta-"+k, v)
		}
	}
	req.Header.Set("x-ms-version", ServiceVersion)
	return req, nil
}

// setMetadataResponder handles the response to the SetMetadata request.
func (client fileClient) setMetadataResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileSetMetadataResponse{rawResponse: resp.Response()}, err
}

// StartCopy copies a blob or file to a destination file within the storage account.
//
// copySource is specifies the URL of the source file or blob, up to 2 KB in length. To copy a file to another file
// within the same storage account, you may use Shared Key to authenticate the source file. If you are copying a file
// from another storage account, or if you are copying a blob from the same storage account or another storage account,
// then you must authenticate the source file or blob using a shared access signature. If the source is a public blob,
// no authentication is required to perform the copy operation. A file in a share snapshot can also be specified as a
// copy source. timeout is the timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> metadata is a name-value pair to associate with a file storage object.
func (client fileClient) StartCopy(ctx context.Context, copySource string, timeout *int32, metadata map[string]string) (*FileStartCopyResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.startCopyPreparer(copySource, timeout, metadata)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.startCopyResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileStartCopyResponse), err
}

// startCopyPreparer prepares the StartCopy request.
func (client fileClient) startCopyPreparer(copySource string, timeout *int32, metadata map[string]string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("PUT", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if metadata != nil {
		for k, v := range metadata {
			req.Header.Set("x-ms-meta-"+k, v)
		}
	}
	req.Header.Set("x-ms-copy-source", copySource)
	return req, nil
}

// startCopyResponder handles the response to the StartCopy request.
func (client fileClient) startCopyResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusAccepted)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileStartCopyResponse{rawResponse: resp.Response()}, err
}

// UploadRange upload a range of bytes to a file.
//
// rangeParameter is specifies the range of bytes to be written. Both the start and end of the range must be specified.
// For an update operation, the range can be up to 4 MB in size. For a clear operation, the range can be up to the
// value of the file's full size. The File service accepts only a single byte range for the Range and 'x-ms-range'
// headers, and the byte range must be specified in the following format: bytes=startByte-endByte. fileRangeWrite is
// specify one of the following options: - Update: Writes the bytes specified by the request body into the specified
// range. The Range and Content-Length headers must match to perform the update. - Clear: Clears the specified range
// and releases the space used in storage for that range. To clear a range, set the Content-Length header to zero, and
// set the Range header to a value that indicates the range to clear, up to maximum file size. contentLength is
// specifies the number of bytes being transmitted in the request body. When the x-ms-write header is set to clear, the
// value of this header must be set to zero. optionalbody is initial data. optionalbody will be closed upon successful
// return. Callers should ensure closure when receiving an error.timeout is the timeout parameter is expressed in
// seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> contentMD5 is an MD5 hash of the content. This hash is used to verify the
// integrity of the data during transport. When the Content-MD5 header is specified, the File service compares the hash
// of the content that has arrived with the header value that was sent. If the two hashes do not match, the operation
// will fail with error code 400 (Bad Request).
func (client fileClient) UploadRange(ctx context.Context, rangeParameter string, fileRangeWrite FileRangeWriteType, contentLength int64, body io.ReadSeeker, timeout *int32, contentMD5 []byte) (*FileUploadRangeResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.uploadRangePreparer(rangeParameter, fileRangeWrite, contentLength, body, timeout, contentMD5)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.uploadRangeResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileUploadRangeResponse), err
}

// uploadRangePreparer prepares the UploadRange request.
func (client fileClient) uploadRangePreparer(rangeParameter string, fileRangeWrite FileRangeWriteType, contentLength int64, body io.ReadSeeker, timeout *int32, contentMD5 []byte) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("PUT", client.url, body)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	params.Set("comp", "range")
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-range", rangeParameter)
	req.Header.Set("x-ms-write", string(fileRangeWrite))
	req.Header.Set("Content-Length", strconv.FormatInt(contentLength, 10))
	if contentMD5 != nil {
		req.Header.Set("Content-MD5", base64.StdEncoding.EncodeToString(contentMD5))
	}
	req.Header.Set("x-ms-version", ServiceVersion)
	return req, nil
}

// uploadRangeResponder handles the response to the UploadRange request.
func (client fileClient) uploadRangeResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusCreated)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileUploadRangeResponse{rawResponse: resp.Response()}, err
}

// UploadRangeFromURL upload a range of bytes to a file where the contents are read from a URL.
//
// rangeParameter is writes data to the specified byte range in the file. copySource is specifies the URL of the source
// file or blob, up to 2 KB in length. To copy a file to another file within the same storage account, you may use
// Shared Key to authenticate the source file. If you are copying a file from another storage account, or if you are
// copying a blob from the same storage account or another storage account, then you must authenticate the source file
// or blob using a shared access signature. If the source is a public blob, no authentication is required to perform
// the copy operation. A file in a share snapshot can also be specified as a copy source. contentLength is specifies
// the number of bytes being transmitted in the request body. When the x-ms-write header is set to clear, the value of
// this header must be set to zero. timeout is the timeout parameter is expressed in seconds. For more information, see
// <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
// Timeouts for File Service Operations.</a> sourceRange is bytes of source data in the specified range.
// sourceContentCrc64 is specify the crc64 calculated for the range of bytes that must be read from the copy source.
// sourceIfMatchCrc64 is specify the crc64 value to operate only on range with a matching crc64 checksum.
// sourceIfNoneMatchCrc64 is specify the crc64 value to operate only on range without a matching crc64 checksum.
func (client fileClient) UploadRangeFromURL(ctx context.Context, rangeParameter string, copySource string, contentLength int64, timeout *int32, sourceRange *string, sourceContentCrc64 []byte, sourceIfMatchCrc64 []byte, sourceIfNoneMatchCrc64 []byte) (*FileUploadRangeFromURLResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.uploadRangeFromURLPreparer(rangeParameter, copySource, contentLength, timeout, sourceRange, sourceContentCrc64, sourceIfMatchCrc64, sourceIfNoneMatchCrc64)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.uploadRangeFromURLResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*FileUploadRangeFromURLResponse), err
}

// uploadRangeFromURLPreparer prepares the UploadRangeFromURL request.
func (client fileClient) uploadRangeFromURLPreparer(rangeParameter string, copySource string, contentLength int64, timeout *int32, sourceRange *string, sourceContentCrc64 []byte, sourceIfMatchCrc64 []byte, sourceIfNoneMatchCrc64 []byte) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("PUT", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	params.Set("comp", "range")
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-range", rangeParameter)
	req.Header.Set("x-ms-copy-source", copySource)
	if sourceRange != nil {
		req.Header.Set("x-ms-source-range", *sourceRange)
	}
	req.Header.Set("x-ms-write", "update")
	req.Header.Set("Content-Length", strconv.FormatInt(contentLength, 10))
	if sourceContentCrc64 != nil {
		req.Header.Set("x-ms-source-content-crc64", base64.StdEncoding.EncodeToString(sourceContentCrc64))
	}
	if sourceIfMatchCrc64 != nil {
		req.Header.Set("x-ms-source-if-match-crc64", base64.StdEncoding.EncodeToString(sourceIfMatchCrc64))
	}
	if sourceIfNoneMatchCrc64 != nil {
		req.Header.Set("x-ms-source-if-none-match-crc64", base64.StdEncoding.EncodeToString(sourceIfNoneMatchCrc64))
	}
	req.Header.Set("x-ms-version", ServiceVersion)
	return req, nil
}

// uploadRangeFromURLResponder handles the response to the UploadRangeFromURL request.
func (client fileClient) uploadRangeFromURLResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusCreated)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &FileUploadRangeFromURLResponse{rawResponse: resp.Response()}, err
}
