package operationalinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PostClient is the log Analytics Data Plane Client
type PostClient struct {
	BaseClient
}

// NewPostClient creates an instance of the PostClient client.
func NewPostClient() PostClient {
	return NewPostClientWithBaseURI(DefaultBaseURI)
}

// NewPostClientWithBaseURI creates an instance of the PostClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewPostClientWithBaseURI(baseURI string) PostClient {
	return PostClient{NewWithBaseURI(baseURI)}
}

// Metadata retrieve the metadata information for the workspace, including its schema, functions, workspace info,
// categories etc.
// Parameters:
// workspaceID - ID of the workspace. This is Workspace ID from the Properties blade in the Azure portal.
func (client PostClient) Metadata(ctx context.Context, workspaceID string) (result MetadataResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PostClient.Metadata")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.MetadataPreparer(ctx, workspaceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.PostClient", "Metadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.MetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "operationalinsights.PostClient", "Metadata", resp, "Failure sending request")
		return
	}

	result, err = client.MetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.PostClient", "Metadata", resp, "Failure responding to request")
	}

	return
}

// MetadataPreparer prepares the Metadata request.
func (client PostClient) MetadataPreparer(ctx context.Context, workspaceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"workspaceId": autorest.Encode("path", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/workspaces/{workspaceId}/metadata", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MetadataSender sends the Metadata request. The method will close the
// http.Response Body if it receives an error.
func (client PostClient) MetadataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// MetadataResponder handles the response to the Metadata request. The method always
// closes the http.Response Body.
func (client PostClient) MetadataResponder(resp *http.Response) (result MetadataResults, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
