// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package containerinstance

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/containerinstance/mgmt/2019-12-01/containerinstance"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ContainerGroupIPAddressType = original.ContainerGroupIPAddressType

const (
	Private ContainerGroupIPAddressType = original.Private
	Public  ContainerGroupIPAddressType = original.Public
)

type ContainerGroupNetworkProtocol = original.ContainerGroupNetworkProtocol

const (
	TCP ContainerGroupNetworkProtocol = original.TCP
	UDP ContainerGroupNetworkProtocol = original.UDP
)

type ContainerGroupRestartPolicy = original.ContainerGroupRestartPolicy

const (
	Always    ContainerGroupRestartPolicy = original.Always
	Never     ContainerGroupRestartPolicy = original.Never
	OnFailure ContainerGroupRestartPolicy = original.OnFailure
)

type ContainerGroupSku = original.ContainerGroupSku

const (
	Dedicated ContainerGroupSku = original.Dedicated
	Standard  ContainerGroupSku = original.Standard
)

type ContainerNetworkProtocol = original.ContainerNetworkProtocol

const (
	ContainerNetworkProtocolTCP ContainerNetworkProtocol = original.ContainerNetworkProtocolTCP
	ContainerNetworkProtocolUDP ContainerNetworkProtocol = original.ContainerNetworkProtocolUDP
)

type GpuSku = original.GpuSku

const (
	K80  GpuSku = original.K80
	P100 GpuSku = original.P100
	V100 GpuSku = original.V100
)

type LogAnalyticsLogType = original.LogAnalyticsLogType

const (
	ContainerInsights     LogAnalyticsLogType = original.ContainerInsights
	ContainerInstanceLogs LogAnalyticsLogType = original.ContainerInstanceLogs
)

type OperatingSystemTypes = original.OperatingSystemTypes

const (
	Linux   OperatingSystemTypes = original.Linux
	Windows OperatingSystemTypes = original.Windows
)

type OperationsOrigin = original.OperationsOrigin

const (
	System OperationsOrigin = original.System
	User   OperationsOrigin = original.User
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	None                       ResourceIdentityType = original.None
	SystemAssigned             ResourceIdentityType = original.SystemAssigned
	SystemAssignedUserAssigned ResourceIdentityType = original.SystemAssignedUserAssigned
	UserAssigned               ResourceIdentityType = original.UserAssigned
)

type Scheme = original.Scheme

const (
	HTTP  Scheme = original.HTTP
	HTTPS Scheme = original.HTTPS
)

type AzureFileVolume = original.AzureFileVolume
type BaseClient = original.BaseClient
type CachedImages = original.CachedImages
type CachedImagesListResult = original.CachedImagesListResult
type CachedImagesListResultIterator = original.CachedImagesListResultIterator
type CachedImagesListResultPage = original.CachedImagesListResultPage
type Capabilities = original.Capabilities
type CapabilitiesCapabilities = original.CapabilitiesCapabilities
type CapabilitiesListResult = original.CapabilitiesListResult
type CapabilitiesListResultIterator = original.CapabilitiesListResultIterator
type CapabilitiesListResultPage = original.CapabilitiesListResultPage
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type Container = original.Container
type ContainerExec = original.ContainerExec
type ContainerExecRequest = original.ContainerExecRequest
type ContainerExecRequestTerminalSize = original.ContainerExecRequestTerminalSize
type ContainerExecResponse = original.ContainerExecResponse
type ContainerGroup = original.ContainerGroup
type ContainerGroupDiagnostics = original.ContainerGroupDiagnostics
type ContainerGroupIdentity = original.ContainerGroupIdentity
type ContainerGroupIdentityUserAssignedIdentitiesValue = original.ContainerGroupIdentityUserAssignedIdentitiesValue
type ContainerGroupListResult = original.ContainerGroupListResult
type ContainerGroupListResultIterator = original.ContainerGroupListResultIterator
type ContainerGroupListResultPage = original.ContainerGroupListResultPage
type ContainerGroupNetworkProfile = original.ContainerGroupNetworkProfile
type ContainerGroupProperties = original.ContainerGroupProperties
type ContainerGroupPropertiesInstanceView = original.ContainerGroupPropertiesInstanceView
type ContainerGroupsClient = original.ContainerGroupsClient
type ContainerGroupsCreateOrUpdateFuture = original.ContainerGroupsCreateOrUpdateFuture
type ContainerGroupsDeleteFuture = original.ContainerGroupsDeleteFuture
type ContainerGroupsRestartFuture = original.ContainerGroupsRestartFuture
type ContainerGroupsStartFuture = original.ContainerGroupsStartFuture
type ContainerHTTPGet = original.ContainerHTTPGet
type ContainerPort = original.ContainerPort
type ContainerProbe = original.ContainerProbe
type ContainerProperties = original.ContainerProperties
type ContainerPropertiesInstanceView = original.ContainerPropertiesInstanceView
type ContainerState = original.ContainerState
type ContainersClient = original.ContainersClient
type DNSConfiguration = original.DNSConfiguration
type EncryptionProperties = original.EncryptionProperties
type EnvironmentVariable = original.EnvironmentVariable
type Event = original.Event
type GitRepoVolume = original.GitRepoVolume
type GpuResource = original.GpuResource
type IPAddress = original.IPAddress
type ImageRegistryCredential = original.ImageRegistryCredential
type InitContainerDefinition = original.InitContainerDefinition
type InitContainerPropertiesDefinition = original.InitContainerPropertiesDefinition
type InitContainerPropertiesDefinitionInstanceView = original.InitContainerPropertiesDefinitionInstanceView
type LocationClient = original.LocationClient
type LogAnalytics = original.LogAnalytics
type Logs = original.Logs
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type Port = original.Port
type Resource = original.Resource
type ResourceLimits = original.ResourceLimits
type ResourceRequests = original.ResourceRequests
type ResourceRequirements = original.ResourceRequirements
type Usage = original.Usage
type UsageListResult = original.UsageListResult
type UsageName = original.UsageName
type Volume = original.Volume
type VolumeMount = original.VolumeMount

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewCachedImagesListResultIterator(page CachedImagesListResultPage) CachedImagesListResultIterator {
	return original.NewCachedImagesListResultIterator(page)
}
func NewCachedImagesListResultPage(getNextPage func(context.Context, CachedImagesListResult) (CachedImagesListResult, error)) CachedImagesListResultPage {
	return original.NewCachedImagesListResultPage(getNextPage)
}
func NewCapabilitiesListResultIterator(page CapabilitiesListResultPage) CapabilitiesListResultIterator {
	return original.NewCapabilitiesListResultIterator(page)
}
func NewCapabilitiesListResultPage(getNextPage func(context.Context, CapabilitiesListResult) (CapabilitiesListResult, error)) CapabilitiesListResultPage {
	return original.NewCapabilitiesListResultPage(getNextPage)
}
func NewContainerGroupListResultIterator(page ContainerGroupListResultPage) ContainerGroupListResultIterator {
	return original.NewContainerGroupListResultIterator(page)
}
func NewContainerGroupListResultPage(getNextPage func(context.Context, ContainerGroupListResult) (ContainerGroupListResult, error)) ContainerGroupListResultPage {
	return original.NewContainerGroupListResultPage(getNextPage)
}
func NewContainerGroupsClient(subscriptionID string) ContainerGroupsClient {
	return original.NewContainerGroupsClient(subscriptionID)
}
func NewContainerGroupsClientWithBaseURI(baseURI string, subscriptionID string) ContainerGroupsClient {
	return original.NewContainerGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewContainersClient(subscriptionID string) ContainersClient {
	return original.NewContainersClient(subscriptionID)
}
func NewContainersClientWithBaseURI(baseURI string, subscriptionID string) ContainersClient {
	return original.NewContainersClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocationClient(subscriptionID string) LocationClient {
	return original.NewLocationClient(subscriptionID)
}
func NewLocationClientWithBaseURI(baseURI string, subscriptionID string) LocationClient {
	return original.NewLocationClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleContainerGroupIPAddressTypeValues() []ContainerGroupIPAddressType {
	return original.PossibleContainerGroupIPAddressTypeValues()
}
func PossibleContainerGroupNetworkProtocolValues() []ContainerGroupNetworkProtocol {
	return original.PossibleContainerGroupNetworkProtocolValues()
}
func PossibleContainerGroupRestartPolicyValues() []ContainerGroupRestartPolicy {
	return original.PossibleContainerGroupRestartPolicyValues()
}
func PossibleContainerGroupSkuValues() []ContainerGroupSku {
	return original.PossibleContainerGroupSkuValues()
}
func PossibleContainerNetworkProtocolValues() []ContainerNetworkProtocol {
	return original.PossibleContainerNetworkProtocolValues()
}
func PossibleGpuSkuValues() []GpuSku {
	return original.PossibleGpuSkuValues()
}
func PossibleLogAnalyticsLogTypeValues() []LogAnalyticsLogType {
	return original.PossibleLogAnalyticsLogTypeValues()
}
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return original.PossibleOperatingSystemTypesValues()
}
func PossibleOperationsOriginValues() []OperationsOrigin {
	return original.PossibleOperationsOriginValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleSchemeValues() []Scheme {
	return original.PossibleSchemeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
