package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGtmAccessStrategy invokes the alidns.AddGtmAccessStrategy API synchronously
func (client *Client) AddGtmAccessStrategy(request *AddGtmAccessStrategyRequest) (response *AddGtmAccessStrategyResponse, err error) {
	response = CreateAddGtmAccessStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// AddGtmAccessStrategyWithChan invokes the alidns.AddGtmAccessStrategy API asynchronously
func (client *Client) AddGtmAccessStrategyWithChan(request *AddGtmAccessStrategyRequest) (<-chan *AddGtmAccessStrategyResponse, <-chan error) {
	responseChan := make(chan *AddGtmAccessStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGtmAccessStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGtmAccessStrategyWithCallback invokes the alidns.AddGtmAccessStrategy API asynchronously
func (client *Client) AddGtmAccessStrategyWithCallback(request *AddGtmAccessStrategyRequest, callback func(response *AddGtmAccessStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGtmAccessStrategyResponse
		var err error
		defer close(result)
		response, err = client.AddGtmAccessStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGtmAccessStrategyRequest is the request struct for api AddGtmAccessStrategy
type AddGtmAccessStrategyRequest struct {
	*requests.RpcRequest
	DefaultAddrPoolId  string `position:"Query" name:"DefaultAddrPoolId"`
	FailoverAddrPoolId string `position:"Query" name:"FailoverAddrPoolId"`
	StrategyName       string `position:"Query" name:"StrategyName"`
	AccessLines        string `position:"Query" name:"AccessLines"`
	InstanceId         string `position:"Query" name:"InstanceId"`
	UserClientIp       string `position:"Query" name:"UserClientIp"`
	Lang               string `position:"Query" name:"Lang"`
}

// AddGtmAccessStrategyResponse is the response struct for api AddGtmAccessStrategy
type AddGtmAccessStrategyResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	StrategyId string `json:"StrategyId" xml:"StrategyId"`
}

// CreateAddGtmAccessStrategyRequest creates a request to invoke AddGtmAccessStrategy API
func CreateAddGtmAccessStrategyRequest() (request *AddGtmAccessStrategyRequest) {
	request = &AddGtmAccessStrategyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "AddGtmAccessStrategy", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddGtmAccessStrategyResponse creates a response to parse from AddGtmAccessStrategy response
func CreateAddGtmAccessStrategyResponse() (response *AddGtmAccessStrategyResponse) {
	response = &AddGtmAccessStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
