package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStack invokes the emr.ListStack API synchronously
func (client *Client) ListStack(request *ListStackRequest) (response *ListStackResponse, err error) {
	response = CreateListStackResponse()
	err = client.DoAction(request, response)
	return
}

// ListStackWithChan invokes the emr.ListStack API asynchronously
func (client *Client) ListStackWithChan(request *ListStackRequest) (<-chan *ListStackResponse, <-chan error) {
	responseChan := make(chan *ListStackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStackWithCallback invokes the emr.ListStack API asynchronously
func (client *Client) ListStackWithCallback(request *ListStackRequest, callback func(response *ListStackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStackResponse
		var err error
		defer close(result)
		response, err = client.ListStack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStackRequest is the request struct for api ListStack
type ListStackRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	StackName       string           `position:"Query" name:"StackName"`
	StackVersion    string           `position:"Query" name:"StackVersion"`
}

// ListStackResponse is the response struct for api ListStack
type ListStackResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	PageNumber int       `json:"PageNumber" xml:"PageNumber"`
	PageSize   int       `json:"PageSize" xml:"PageSize"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	StackList  StackList `json:"StackList" xml:"StackList"`
}

// CreateListStackRequest creates a request to invoke ListStack API
func CreateListStackRequest() (request *ListStackRequest) {
	request = &ListStackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListStack", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListStackResponse creates a response to parse from ListStack response
func CreateListStackResponse() (response *ListStackResponse) {
	response = &ListStackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
