package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyExecutionPlan invokes the emr.ModifyExecutionPlan API synchronously
func (client *Client) ModifyExecutionPlan(request *ModifyExecutionPlanRequest) (response *ModifyExecutionPlanResponse, err error) {
	response = CreateModifyExecutionPlanResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyExecutionPlanWithChan invokes the emr.ModifyExecutionPlan API asynchronously
func (client *Client) ModifyExecutionPlanWithChan(request *ModifyExecutionPlanRequest) (<-chan *ModifyExecutionPlanResponse, <-chan error) {
	responseChan := make(chan *ModifyExecutionPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyExecutionPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyExecutionPlanWithCallback invokes the emr.ModifyExecutionPlan API asynchronously
func (client *Client) ModifyExecutionPlanWithCallback(request *ModifyExecutionPlanRequest, callback func(response *ModifyExecutionPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyExecutionPlanResponse
		var err error
		defer close(result)
		response, err = client.ModifyExecutionPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyExecutionPlanRequest is the request struct for api ModifyExecutionPlan
type ModifyExecutionPlanRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	LogPath                string                                `position:"Query" name:"LogPath"`
	TimeInterval           requests.Integer                      `position:"Query" name:"TimeInterval"`
	ClusterName            string                                `position:"Query" name:"ClusterName"`
	Configurations         string                                `position:"Query" name:"Configurations"`
	CreateClusterOnDemand  requests.Boolean                      `position:"Query" name:"CreateClusterOnDemand"`
	StartTime              requests.Integer                      `position:"Query" name:"StartTime"`
	BootstrapAction        *[]ModifyExecutionPlanBootstrapAction `position:"Query" name:"BootstrapAction"  type:"Repeated"`
	EmrVer                 string                                `position:"Query" name:"EmrVer"`
	Id                     string                                `position:"Query" name:"Id"`
	IsOpenPublicIp         requests.Boolean                      `position:"Query" name:"IsOpenPublicIp"`
	ExecutionPlanVersion   requests.Integer                      `position:"Query" name:"ExecutionPlanVersion"`
	InstanceGeneration     string                                `position:"Query" name:"InstanceGeneration"`
	ClusterType            string                                `position:"Query" name:"ClusterType"`
	VSwitchId              string                                `position:"Query" name:"VSwitchId"`
	OptionSoftWareList     *[]string                             `position:"Query" name:"OptionSoftWareList"  type:"Repeated"`
	NetType                string                                `position:"Query" name:"NetType"`
	EcsOrder               *[]ModifyExecutionPlanEcsOrder        `position:"Query" name:"EcsOrder"  type:"Repeated"`
	Name                   string                                `position:"Query" name:"Name"`
	ZoneId                 string                                `position:"Query" name:"ZoneId"`
	UseCustomHiveMetaDB    requests.Boolean                      `position:"Query" name:"UseCustomHiveMetaDB"`
	InitCustomHiveMetaDB   requests.Boolean                      `position:"Query" name:"InitCustomHiveMetaDB"`
	IoOptimized            requests.Boolean                      `position:"Query" name:"IoOptimized"`
	SecurityGroupId        string                                `position:"Query" name:"SecurityGroupId"`
	EasEnable              requests.Boolean                      `position:"Query" name:"EasEnable"`
	JobIdList              *[]string                             `position:"Query" name:"JobIdList"  type:"Repeated"`
	DayOfMonth             string                                `position:"Query" name:"DayOfMonth"`
	UseLocalMetaDb         requests.Boolean                      `position:"Query" name:"UseLocalMetaDb"`
	UserDefinedEmrEcsRole  string                                `position:"Query" name:"UserDefinedEmrEcsRole"`
	ClusterId              string                                `position:"Query" name:"ClusterId"`
	TimeUnit               string                                `position:"Query" name:"TimeUnit"`
	VpcId                  string                                `position:"Query" name:"VpcId"`
	WorkflowDefinition     string                                `position:"Query" name:"WorkflowDefinition"`
	DayOfWeek              string                                `position:"Query" name:"DayOfWeek"`
	Strategy               string                                `position:"Query" name:"Strategy"`
	Config                 *[]ModifyExecutionPlanConfig          `position:"Query" name:"Config"  type:"Repeated"`
	HighAvailabilityEnable requests.Boolean                      `position:"Query" name:"HighAvailabilityEnable"`
	LogEnable              requests.Boolean                      `position:"Query" name:"LogEnable"`
}

// ModifyExecutionPlanBootstrapAction is a repeated param struct in ModifyExecutionPlanRequest
type ModifyExecutionPlanBootstrapAction struct {
	Path                  string `name:"Path"`
	ExecutionTarget       string `name:"ExecutionTarget"`
	ExecutionMoment       string `name:"ExecutionMoment"`
	Arg                   string `name:"Arg"`
	Name                  string `name:"Name"`
	ExecutionFailStrategy string `name:"ExecutionFailStrategy"`
}

// ModifyExecutionPlanEcsOrder is a repeated param struct in ModifyExecutionPlanRequest
type ModifyExecutionPlanEcsOrder struct {
	NodeType     string `name:"NodeType"`
	DiskCount    string `name:"DiskCount"`
	NodeCount    string `name:"NodeCount"`
	DiskCapacity string `name:"DiskCapacity"`
	Index        string `name:"Index"`
	InstanceType string `name:"InstanceType"`
	DiskType     string `name:"DiskType"`
}

// ModifyExecutionPlanConfig is a repeated param struct in ModifyExecutionPlanRequest
type ModifyExecutionPlanConfig struct {
	ConfigKey   string `name:"ConfigKey"`
	FileName    string `name:"FileName"`
	Encrypt     string `name:"Encrypt"`
	Replace     string `name:"Replace"`
	ConfigValue string `name:"ConfigValue"`
	ServiceName string `name:"ServiceName"`
}

// ModifyExecutionPlanResponse is the response struct for api ModifyExecutionPlan
type ModifyExecutionPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyExecutionPlanRequest creates a request to invoke ModifyExecutionPlan API
func CreateModifyExecutionPlanRequest() (request *ModifyExecutionPlanRequest) {
	request = &ModifyExecutionPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyExecutionPlan", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyExecutionPlanResponse creates a response to parse from ModifyExecutionPlan response
func CreateModifyExecutionPlanResponse() (response *ModifyExecutionPlanResponse) {
	response = &ModifyExecutionPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
