package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIngestionJob invokes the sls.DeleteIngestionJob API synchronously
func (client *Client) DeleteIngestionJob(request *DeleteIngestionJobRequest) (response *DeleteIngestionJobResponse, err error) {
	response = CreateDeleteIngestionJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIngestionJobWithChan invokes the sls.DeleteIngestionJob API asynchronously
func (client *Client) DeleteIngestionJobWithChan(request *DeleteIngestionJobRequest) (<-chan *DeleteIngestionJobResponse, <-chan error) {
	responseChan := make(chan *DeleteIngestionJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIngestionJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIngestionJobWithCallback invokes the sls.DeleteIngestionJob API asynchronously
func (client *Client) DeleteIngestionJobWithCallback(request *DeleteIngestionJobRequest, callback func(response *DeleteIngestionJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIngestionJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteIngestionJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIngestionJobRequest is the request struct for api DeleteIngestionJob
type DeleteIngestionJobRequest struct {
	*requests.RpcRequest
	Namespace string `position:"Body" name:"Namespace"`
	Region    string `position:"Body" name:"Region"`
	JobName   string `position:"Body" name:"JobName"`
}

// DeleteIngestionJobResponse is the response struct for api DeleteIngestionJob
type DeleteIngestionJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteIngestionJobRequest creates a request to invoke DeleteIngestionJob API
func CreateDeleteIngestionJobRequest() (request *DeleteIngestionJobRequest) {
	request = &DeleteIngestionJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "DeleteIngestionJob", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteIngestionJobResponse creates a response to parse from DeleteIngestionJob response
func CreateDeleteIngestionJobResponse() (response *DeleteIngestionJobResponse) {
	response = &DeleteIngestionJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
