package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSmartAGDpiAttribute invokes the smartag.GetSmartAGDpiAttribute API synchronously
func (client *Client) GetSmartAGDpiAttribute(request *GetSmartAGDpiAttributeRequest) (response *GetSmartAGDpiAttributeResponse, err error) {
	response = CreateGetSmartAGDpiAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// GetSmartAGDpiAttributeWithChan invokes the smartag.GetSmartAGDpiAttribute API asynchronously
func (client *Client) GetSmartAGDpiAttributeWithChan(request *GetSmartAGDpiAttributeRequest) (<-chan *GetSmartAGDpiAttributeResponse, <-chan error) {
	responseChan := make(chan *GetSmartAGDpiAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSmartAGDpiAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSmartAGDpiAttributeWithCallback invokes the smartag.GetSmartAGDpiAttribute API asynchronously
func (client *Client) GetSmartAGDpiAttributeWithCallback(request *GetSmartAGDpiAttributeRequest, callback func(response *GetSmartAGDpiAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSmartAGDpiAttributeResponse
		var err error
		defer close(result)
		response, err = client.GetSmartAGDpiAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSmartAGDpiAttributeRequest is the request struct for api GetSmartAGDpiAttribute
type GetSmartAGDpiAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// GetSmartAGDpiAttributeResponse is the response struct for api GetSmartAGDpiAttribute
type GetSmartAGDpiAttributeResponse struct {
	*responses.BaseResponse
	LogstoreName     string `json:"LogstoreName" xml:"LogstoreName"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
	ProjectName      string `json:"ProjectName" xml:"ProjectName"`
	SlsRegion        string `json:"SlsRegion" xml:"SlsRegion"`
	DpiMonitorStatus string `json:"DpiMonitorStatus" xml:"DpiMonitorStatus"`
	DpiStatus        string `json:"DpiStatus" xml:"DpiStatus"`
}

// CreateGetSmartAGDpiAttributeRequest creates a request to invoke GetSmartAGDpiAttribute API
func CreateGetSmartAGDpiAttributeRequest() (request *GetSmartAGDpiAttributeRequest) {
	request = &GetSmartAGDpiAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "GetSmartAGDpiAttribute", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSmartAGDpiAttributeResponse creates a response to parse from GetSmartAGDpiAttribute response
func CreateGetSmartAGDpiAttributeResponse() (response *GetSmartAGDpiAttributeResponse) {
	response = &GetSmartAGDpiAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
