// Code generated by go-swagger; DO NOT EDIT.

package p_cloud_events

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewPcloudEventsGetParams creates a new PcloudEventsGetParams object
// with the default values initialized.
func NewPcloudEventsGetParams() *PcloudEventsGetParams {
	var ()
	return &PcloudEventsGetParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewPcloudEventsGetParamsWithTimeout creates a new PcloudEventsGetParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewPcloudEventsGetParamsWithTimeout(timeout time.Duration) *PcloudEventsGetParams {
	var ()
	return &PcloudEventsGetParams{

		timeout: timeout,
	}
}

// NewPcloudEventsGetParamsWithContext creates a new PcloudEventsGetParams object
// with the default values initialized, and the ability to set a context for a request
func NewPcloudEventsGetParamsWithContext(ctx context.Context) *PcloudEventsGetParams {
	var ()
	return &PcloudEventsGetParams{

		Context: ctx,
	}
}

// NewPcloudEventsGetParamsWithHTTPClient creates a new PcloudEventsGetParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewPcloudEventsGetParamsWithHTTPClient(client *http.Client) *PcloudEventsGetParams {
	var ()
	return &PcloudEventsGetParams{
		HTTPClient: client,
	}
}

/*PcloudEventsGetParams contains all the parameters to send to the API endpoint
for the pcloud events get operation typically these are written to a http.Request
*/
type PcloudEventsGetParams struct {

	/*AcceptLanguage
	  The language requested for the return document

	*/
	AcceptLanguage *string
	/*CloudInstanceID
	  Cloud Instance ID of a PCloud Instance

	*/
	CloudInstanceID string
	/*EventID
	  Event ID

	*/
	EventID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the pcloud events get params
func (o *PcloudEventsGetParams) WithTimeout(timeout time.Duration) *PcloudEventsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the pcloud events get params
func (o *PcloudEventsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the pcloud events get params
func (o *PcloudEventsGetParams) WithContext(ctx context.Context) *PcloudEventsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the pcloud events get params
func (o *PcloudEventsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the pcloud events get params
func (o *PcloudEventsGetParams) WithHTTPClient(client *http.Client) *PcloudEventsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the pcloud events get params
func (o *PcloudEventsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAcceptLanguage adds the acceptLanguage to the pcloud events get params
func (o *PcloudEventsGetParams) WithAcceptLanguage(acceptLanguage *string) *PcloudEventsGetParams {
	o.SetAcceptLanguage(acceptLanguage)
	return o
}

// SetAcceptLanguage adds the acceptLanguage to the pcloud events get params
func (o *PcloudEventsGetParams) SetAcceptLanguage(acceptLanguage *string) {
	o.AcceptLanguage = acceptLanguage
}

// WithCloudInstanceID adds the cloudInstanceID to the pcloud events get params
func (o *PcloudEventsGetParams) WithCloudInstanceID(cloudInstanceID string) *PcloudEventsGetParams {
	o.SetCloudInstanceID(cloudInstanceID)
	return o
}

// SetCloudInstanceID adds the cloudInstanceId to the pcloud events get params
func (o *PcloudEventsGetParams) SetCloudInstanceID(cloudInstanceID string) {
	o.CloudInstanceID = cloudInstanceID
}

// WithEventID adds the eventID to the pcloud events get params
func (o *PcloudEventsGetParams) WithEventID(eventID string) *PcloudEventsGetParams {
	o.SetEventID(eventID)
	return o
}

// SetEventID adds the eventId to the pcloud events get params
func (o *PcloudEventsGetParams) SetEventID(eventID string) {
	o.EventID = eventID
}

// WriteToRequest writes these params to a swagger request
func (o *PcloudEventsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AcceptLanguage != nil {

		// header param Accept-Language
		if err := r.SetHeaderParam("Accept-Language", *o.AcceptLanguage); err != nil {
			return err
		}

	}

	// path param cloud_instance_id
	if err := r.SetPathParam("cloud_instance_id", o.CloudInstanceID); err != nil {
		return err
	}

	// path param event_id
	if err := r.SetPathParam("event_id", o.EventID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
