package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RelieveAccountRelation invokes the bssopenapi.RelieveAccountRelation API synchronously
func (client *Client) RelieveAccountRelation(request *RelieveAccountRelationRequest) (response *RelieveAccountRelationResponse, err error) {
	response = CreateRelieveAccountRelationResponse()
	err = client.DoAction(request, response)
	return
}

// RelieveAccountRelationWithChan invokes the bssopenapi.RelieveAccountRelation API asynchronously
func (client *Client) RelieveAccountRelationWithChan(request *RelieveAccountRelationRequest) (<-chan *RelieveAccountRelationResponse, <-chan error) {
	responseChan := make(chan *RelieveAccountRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RelieveAccountRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RelieveAccountRelationWithCallback invokes the bssopenapi.RelieveAccountRelation API asynchronously
func (client *Client) RelieveAccountRelationWithCallback(request *RelieveAccountRelationRequest, callback func(response *RelieveAccountRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RelieveAccountRelationResponse
		var err error
		defer close(result)
		response, err = client.RelieveAccountRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RelieveAccountRelationRequest is the request struct for api RelieveAccountRelation
type RelieveAccountRelationRequest struct {
	*requests.RpcRequest
	RelationType string           `position:"Query" name:"RelationType"`
	ParentUserId requests.Integer `position:"Query" name:"ParentUserId"`
	ChildUserId  requests.Integer `position:"Query" name:"ChildUserId"`
	RequestId    string           `position:"Query" name:"RequestId"`
}

// RelieveAccountRelationResponse is the response struct for api RelieveAccountRelation
type RelieveAccountRelationResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRelieveAccountRelationRequest creates a request to invoke RelieveAccountRelation API
func CreateRelieveAccountRelationRequest() (request *RelieveAccountRelationRequest) {
	request = &RelieveAccountRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "RelieveAccountRelation", "", "")
	request.Method = requests.POST
	return
}

// CreateRelieveAccountRelationResponse creates a response to parse from RelieveAccountRelation response
func CreateRelieveAccountRelationResponse() (response *RelieveAccountRelationResponse) {
	response = &RelieveAccountRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
