package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCenChildInstanceRouteEntryToCen invokes the cbn.DeleteCenChildInstanceRouteEntryToCen API synchronously
func (client *Client) DeleteCenChildInstanceRouteEntryToCen(request *DeleteCenChildInstanceRouteEntryToCenRequest) (response *DeleteCenChildInstanceRouteEntryToCenResponse, err error) {
	response = CreateDeleteCenChildInstanceRouteEntryToCenResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCenChildInstanceRouteEntryToCenWithChan invokes the cbn.DeleteCenChildInstanceRouteEntryToCen API asynchronously
func (client *Client) DeleteCenChildInstanceRouteEntryToCenWithChan(request *DeleteCenChildInstanceRouteEntryToCenRequest) (<-chan *DeleteCenChildInstanceRouteEntryToCenResponse, <-chan error) {
	responseChan := make(chan *DeleteCenChildInstanceRouteEntryToCenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCenChildInstanceRouteEntryToCen(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCenChildInstanceRouteEntryToCenWithCallback invokes the cbn.DeleteCenChildInstanceRouteEntryToCen API asynchronously
func (client *Client) DeleteCenChildInstanceRouteEntryToCenWithCallback(request *DeleteCenChildInstanceRouteEntryToCenRequest, callback func(response *DeleteCenChildInstanceRouteEntryToCenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCenChildInstanceRouteEntryToCenResponse
		var err error
		defer close(result)
		response, err = client.DeleteCenChildInstanceRouteEntryToCen(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCenChildInstanceRouteEntryToCenRequest is the request struct for api DeleteCenChildInstanceRouteEntryToCen
type DeleteCenChildInstanceRouteEntryToCenRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                 string           `position:"Query" name:"CenId"`
	ChildInstanceRegionId string           `position:"Query" name:"ChildInstanceRegionId"`
	RouteTableId          string           `position:"Query" name:"RouteTableId"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	DestinationCidrBlock  string           `position:"Query" name:"DestinationCidrBlock"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	ChildInstanceType     string           `position:"Query" name:"ChildInstanceType"`
	ChildInstanceId       string           `position:"Query" name:"ChildInstanceId"`
	ChildInstanceAliUid   requests.Integer `position:"Query" name:"ChildInstanceAliUid"`
}

// DeleteCenChildInstanceRouteEntryToCenResponse is the response struct for api DeleteCenChildInstanceRouteEntryToCen
type DeleteCenChildInstanceRouteEntryToCenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCenChildInstanceRouteEntryToCenRequest creates a request to invoke DeleteCenChildInstanceRouteEntryToCen API
func CreateDeleteCenChildInstanceRouteEntryToCenRequest() (request *DeleteCenChildInstanceRouteEntryToCenRequest) {
	request = &DeleteCenChildInstanceRouteEntryToCenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DeleteCenChildInstanceRouteEntryToCen", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCenChildInstanceRouteEntryToCenResponse creates a response to parse from DeleteCenChildInstanceRouteEntryToCen response
func CreateDeleteCenChildInstanceRouteEntryToCenResponse() (response *DeleteCenChildInstanceRouteEntryToCenResponse) {
	response = &DeleteCenChildInstanceRouteEntryToCenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
