package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnReportList invokes the dcdn.DescribeDcdnReportList API synchronously
func (client *Client) DescribeDcdnReportList(request *DescribeDcdnReportListRequest) (response *DescribeDcdnReportListResponse, err error) {
	response = CreateDescribeDcdnReportListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnReportListWithChan invokes the dcdn.DescribeDcdnReportList API asynchronously
func (client *Client) DescribeDcdnReportListWithChan(request *DescribeDcdnReportListRequest) (<-chan *DescribeDcdnReportListResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnReportListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnReportList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnReportListWithCallback invokes the dcdn.DescribeDcdnReportList API asynchronously
func (client *Client) DescribeDcdnReportListWithCallback(request *DescribeDcdnReportListRequest, callback func(response *DescribeDcdnReportListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnReportListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnReportList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnReportListRequest is the request struct for api DescribeDcdnReportList
type DescribeDcdnReportListRequest struct {
	*requests.RpcRequest
	ReportId   requests.Integer `position:"Query" name:"ReportId"`
	Permission string           `position:"Query" name:"Permission"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Status     string           `position:"Query" name:"Status"`
}

// DescribeDcdnReportListResponse is the response struct for api DescribeDcdnReportList
type DescribeDcdnReportListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Content   string `json:"Content" xml:"Content"`
}

// CreateDescribeDcdnReportListRequest creates a request to invoke DescribeDcdnReportList API
func CreateDescribeDcdnReportListRequest() (request *DescribeDcdnReportListRequest) {
	request = &DescribeDcdnReportListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnReportList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnReportListResponse creates a response to parse from DescribeDcdnReportList response
func CreateDescribeDcdnReportListResponse() (response *DescribeDcdnReportListResponse) {
	response = &DescribeDcdnReportListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
