package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DecommissionHostComponent invokes the emr.DecommissionHostComponent API synchronously
func (client *Client) DecommissionHostComponent(request *DecommissionHostComponentRequest) (response *DecommissionHostComponentResponse, err error) {
	response = CreateDecommissionHostComponentResponse()
	err = client.DoAction(request, response)
	return
}

// DecommissionHostComponentWithChan invokes the emr.DecommissionHostComponent API asynchronously
func (client *Client) DecommissionHostComponentWithChan(request *DecommissionHostComponentRequest) (<-chan *DecommissionHostComponentResponse, <-chan error) {
	responseChan := make(chan *DecommissionHostComponentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DecommissionHostComponent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DecommissionHostComponentWithCallback invokes the emr.DecommissionHostComponent API asynchronously
func (client *Client) DecommissionHostComponentWithCallback(request *DecommissionHostComponentRequest, callback func(response *DecommissionHostComponentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DecommissionHostComponentResponse
		var err error
		defer close(result)
		response, err = client.DecommissionHostComponent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DecommissionHostComponentRequest is the request struct for api DecommissionHostComponent
type DecommissionHostComponentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostInstanceId  string           `position:"Query" name:"HostInstanceId"`
	ComponentName   string           `position:"Query" name:"ComponentName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	TimeoutSeconds  requests.Integer `position:"Query" name:"TimeoutSeconds"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
}

// DecommissionHostComponentResponse is the response struct for api DecommissionHostComponent
type DecommissionHostComponentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDecommissionHostComponentRequest creates a request to invoke DecommissionHostComponent API
func CreateDecommissionHostComponentRequest() (request *DecommissionHostComponentRequest) {
	request = &DecommissionHostComponentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DecommissionHostComponent", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDecommissionHostComponentResponse creates a response to parse from DecommissionHostComponent response
func CreateDecommissionHostComponentResponse() (response *DecommissionHostComponentResponse) {
	response = &DecommissionHostComponentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
