package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachAndReleaseClusterEni invokes the emr.DetachAndReleaseClusterEni API synchronously
func (client *Client) DetachAndReleaseClusterEni(request *DetachAndReleaseClusterEniRequest) (response *DetachAndReleaseClusterEniResponse, err error) {
	response = CreateDetachAndReleaseClusterEniResponse()
	err = client.DoAction(request, response)
	return
}

// DetachAndReleaseClusterEniWithChan invokes the emr.DetachAndReleaseClusterEni API asynchronously
func (client *Client) DetachAndReleaseClusterEniWithChan(request *DetachAndReleaseClusterEniRequest) (<-chan *DetachAndReleaseClusterEniResponse, <-chan error) {
	responseChan := make(chan *DetachAndReleaseClusterEniResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachAndReleaseClusterEni(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachAndReleaseClusterEniWithCallback invokes the emr.DetachAndReleaseClusterEni API asynchronously
func (client *Client) DetachAndReleaseClusterEniWithCallback(request *DetachAndReleaseClusterEniRequest, callback func(response *DetachAndReleaseClusterEniResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachAndReleaseClusterEniResponse
		var err error
		defer close(result)
		response, err = client.DetachAndReleaseClusterEni(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachAndReleaseClusterEniRequest is the request struct for api DetachAndReleaseClusterEni
type DetachAndReleaseClusterEniRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TargetClusterId string           `position:"Query" name:"TargetClusterId"`
	VswitchId       string           `position:"Query" name:"VswitchId"`
}

// DetachAndReleaseClusterEniResponse is the response struct for api DetachAndReleaseClusterEni
type DetachAndReleaseClusterEniResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachAndReleaseClusterEniRequest creates a request to invoke DetachAndReleaseClusterEni API
func CreateDetachAndReleaseClusterEniRequest() (request *DetachAndReleaseClusterEniRequest) {
	request = &DetachAndReleaseClusterEniRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DetachAndReleaseClusterEni", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachAndReleaseClusterEniResponse creates a response to parse from DetachAndReleaseClusterEni response
func CreateDetachAndReleaseClusterEniResponse() (response *DetachAndReleaseClusterEniResponse) {
	response = &DetachAndReleaseClusterEniResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
