package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AnalyzeAppLog invokes the sls.AnalyzeAppLog API synchronously
func (client *Client) AnalyzeAppLog(request *AnalyzeAppLogRequest) (response *AnalyzeAppLogResponse, err error) {
	response = CreateAnalyzeAppLogResponse()
	err = client.DoAction(request, response)
	return
}

// AnalyzeAppLogWithChan invokes the sls.AnalyzeAppLog API asynchronously
func (client *Client) AnalyzeAppLogWithChan(request *AnalyzeAppLogRequest) (<-chan *AnalyzeAppLogResponse, <-chan error) {
	responseChan := make(chan *AnalyzeAppLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AnalyzeAppLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AnalyzeAppLogWithCallback invokes the sls.AnalyzeAppLog API asynchronously
func (client *Client) AnalyzeAppLogWithCallback(request *AnalyzeAppLogRequest, callback func(response *AnalyzeAppLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AnalyzeAppLogResponse
		var err error
		defer close(result)
		response, err = client.AnalyzeAppLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AnalyzeAppLogRequest is the request struct for api AnalyzeAppLog
type AnalyzeAppLogRequest struct {
	*requests.RpcRequest
	AppType     string `position:"Query" name:"AppType"`
	VariableMap string `position:"Query" name:"VariableMap"`
	DisplayName string `position:"Query" name:"DisplayName"`
}

// AnalyzeAppLogResponse is the response struct for api AnalyzeAppLog
type AnalyzeAppLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateAnalyzeAppLogRequest creates a request to invoke AnalyzeAppLog API
func CreateAnalyzeAppLogRequest() (request *AnalyzeAppLogRequest) {
	request = &AnalyzeAppLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "AnalyzeAppLog", "", "")
	request.Method = requests.POST
	return
}

// CreateAnalyzeAppLogResponse creates a response to parse from AnalyzeAppLog response
func CreateAnalyzeAppLogResponse() (response *AnalyzeAppLogResponse) {
	response = &AnalyzeAppLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
