// Code generated by go-swagger; DO NOT EDIT.

package service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewServiceInstanceGetParams creates a new ServiceInstanceGetParams object
// with the default values initialized.
func NewServiceInstanceGetParams() *ServiceInstanceGetParams {
	var ()
	return &ServiceInstanceGetParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewServiceInstanceGetParamsWithTimeout creates a new ServiceInstanceGetParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewServiceInstanceGetParamsWithTimeout(timeout time.Duration) *ServiceInstanceGetParams {
	var ()
	return &ServiceInstanceGetParams{

		timeout: timeout,
	}
}

// NewServiceInstanceGetParamsWithContext creates a new ServiceInstanceGetParams object
// with the default values initialized, and the ability to set a context for a request
func NewServiceInstanceGetParamsWithContext(ctx context.Context) *ServiceInstanceGetParams {
	var ()
	return &ServiceInstanceGetParams{

		Context: ctx,
	}
}

// NewServiceInstanceGetParamsWithHTTPClient creates a new ServiceInstanceGetParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewServiceInstanceGetParamsWithHTTPClient(client *http.Client) *ServiceInstanceGetParams {
	var ()
	return &ServiceInstanceGetParams{
		HTTPClient: client,
	}
}

/*ServiceInstanceGetParams contains all the parameters to send to the API endpoint
for the service instance get operation typically these are written to a http.Request
*/
type ServiceInstanceGetParams struct {

	/*XBrokerAPIOriginatingIdentity
	  identity of the user that initiated the request from the Platform

	*/
	XBrokerAPIOriginatingIdentity *string
	/*XBrokerAPIVersion
	  version number of the Service Broker API that the Platform will use

	*/
	XBrokerAPIVersion string
	/*InstanceID
	  instance id of instance to provision

	*/
	InstanceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the service instance get params
func (o *ServiceInstanceGetParams) WithTimeout(timeout time.Duration) *ServiceInstanceGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the service instance get params
func (o *ServiceInstanceGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the service instance get params
func (o *ServiceInstanceGetParams) WithContext(ctx context.Context) *ServiceInstanceGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the service instance get params
func (o *ServiceInstanceGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the service instance get params
func (o *ServiceInstanceGetParams) WithHTTPClient(client *http.Client) *ServiceInstanceGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the service instance get params
func (o *ServiceInstanceGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithXBrokerAPIOriginatingIdentity adds the xBrokerAPIOriginatingIdentity to the service instance get params
func (o *ServiceInstanceGetParams) WithXBrokerAPIOriginatingIdentity(xBrokerAPIOriginatingIdentity *string) *ServiceInstanceGetParams {
	o.SetXBrokerAPIOriginatingIdentity(xBrokerAPIOriginatingIdentity)
	return o
}

// SetXBrokerAPIOriginatingIdentity adds the xBrokerApiOriginatingIdentity to the service instance get params
func (o *ServiceInstanceGetParams) SetXBrokerAPIOriginatingIdentity(xBrokerAPIOriginatingIdentity *string) {
	o.XBrokerAPIOriginatingIdentity = xBrokerAPIOriginatingIdentity
}

// WithXBrokerAPIVersion adds the xBrokerAPIVersion to the service instance get params
func (o *ServiceInstanceGetParams) WithXBrokerAPIVersion(xBrokerAPIVersion string) *ServiceInstanceGetParams {
	o.SetXBrokerAPIVersion(xBrokerAPIVersion)
	return o
}

// SetXBrokerAPIVersion adds the xBrokerApiVersion to the service instance get params
func (o *ServiceInstanceGetParams) SetXBrokerAPIVersion(xBrokerAPIVersion string) {
	o.XBrokerAPIVersion = xBrokerAPIVersion
}

// WithInstanceID adds the instanceID to the service instance get params
func (o *ServiceInstanceGetParams) WithInstanceID(instanceID string) *ServiceInstanceGetParams {
	o.SetInstanceID(instanceID)
	return o
}

// SetInstanceID adds the instanceId to the service instance get params
func (o *ServiceInstanceGetParams) SetInstanceID(instanceID string) {
	o.InstanceID = instanceID
}

// WriteToRequest writes these params to a swagger request
func (o *ServiceInstanceGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.XBrokerAPIOriginatingIdentity != nil {

		// header param X-Broker-API-Originating-Identity
		if err := r.SetHeaderParam("X-Broker-API-Originating-Identity", *o.XBrokerAPIOriginatingIdentity); err != nil {
			return err
		}

	}

	// header param X-Broker-API-Version
	if err := r.SetHeaderParam("X-Broker-API-Version", o.XBrokerAPIVersion); err != nil {
		return err
	}

	// path param instance_id
	if err := r.SetPathParam("instance_id", o.InstanceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
