package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFaceUsage invokes the cloudauth.DescribeFaceUsage API synchronously
func (client *Client) DescribeFaceUsage(request *DescribeFaceUsageRequest) (response *DescribeFaceUsageResponse, err error) {
	response = CreateDescribeFaceUsageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFaceUsageWithChan invokes the cloudauth.DescribeFaceUsage API asynchronously
func (client *Client) DescribeFaceUsageWithChan(request *DescribeFaceUsageRequest) (<-chan *DescribeFaceUsageResponse, <-chan error) {
	responseChan := make(chan *DescribeFaceUsageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFaceUsage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFaceUsageWithCallback invokes the cloudauth.DescribeFaceUsage API asynchronously
func (client *Client) DescribeFaceUsageWithCallback(request *DescribeFaceUsageRequest, callback func(response *DescribeFaceUsageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFaceUsageResponse
		var err error
		defer close(result)
		response, err = client.DescribeFaceUsage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFaceUsageRequest is the request struct for api DescribeFaceUsage
type DescribeFaceUsageRequest struct {
	*requests.RpcRequest
	StartDate string `position:"Query" name:"StartDate"`
	EndDate   string `position:"Query" name:"EndDate"`
	SourceIp  string `position:"Query" name:"SourceIp"`
}

// DescribeFaceUsageResponse is the response struct for api DescribeFaceUsage
type DescribeFaceUsageResponse struct {
	*responses.BaseResponse
	RequestId     string      `json:"RequestId" xml:"RequestId"`
	TotalCount    int         `json:"TotalCount" xml:"TotalCount"`
	FaceUsageList []FaceUsage `json:"FaceUsageList" xml:"FaceUsageList"`
}

// CreateDescribeFaceUsageRequest creates a request to invoke DescribeFaceUsage API
func CreateDescribeFaceUsageRequest() (request *DescribeFaceUsageRequest) {
	request = &DescribeFaceUsageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DescribeFaceUsage", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeFaceUsageResponse creates a response to parse from DescribeFaceUsage response
func CreateDescribeFaceUsageResponse() (response *DescribeFaceUsageResponse) {
	response = &DescribeFaceUsageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
